/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ALDecider;
import de.uni_leipzig.simba.genetics.core.ALFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.ExampleOracleTrimmer;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.PseudoEvalFileLogger;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.util.Clock;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.ProgramChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALEvaluation {
    public static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    public static final int RUNS = 1;
    public static final int oracleQuestions = 10;
    public DataSetChooser.DataSets currentDataSet;
    HashMap<String, Object> params;
    public ALFitnessFunction fitness;
    Oracle o;
    ConfigReader cR;
    List<EvaluationPseudoMemory> perRunMemory = new LinkedList<EvaluationPseudoMemory>();
    List<EvaluationPseudoMemory> perDatasetMemory = new LinkedList<EvaluationPseudoMemory>();
    private float mutationCrossRate = 0.6f;
    private float reproduction = 0.7f;
    public boolean restrictGetAllMaps = false;
    public int maxMaps = 20;

    public void run(DataSetChooser.DataSets data, int popSize, int gens, int numberOfExamples, int inquiries) throws InvalidConfigurationException {
        logger.info("Running dataset " + (Object)((Object)data));
        this.currentDataSet = data;
        this.params = DataSetChooser.getData(data);
        String name = ((String)this.params.get("evalfilename")).replaceAll("Pseudo_eval_", "AL_");
        this.params.put("evalfilename", name);
        this.cR = new ConfigReader();
        this.cR.validateAndRead("" + this.params.get("basefolder") + this.params.get("config"));
        String verificationFile = "" + this.params.get("basefolder") + this.params.get("datasetfolder") + this.params.get("reference");
        this.o = OracleFactory.getOracle(verificationFile, verificationFile.substring(verificationFile.lastIndexOf(".") + 1), "simple");
        for (int run = 1; run <= 1; ++run) {
            LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(this.cR.sourceInfo, this.cR.targetInfo, (PropertyMapping)this.params.get("propertymapping"));
            config.setSelectFromPrevGen(this.reproduction);
            config.setCrossoverProb(this.mutationCrossRate);
            config.setMutationProb(this.mutationCrossRate);
            config.setReproductionProb(this.reproduction);
            config.setPopulationSize(popSize);
            config.setPreservFittestIndividual(true);
            config.setAlwaysCaculateFitness(true);
            logger.info("Starting run " + run);
            this.fitness = new ALFitnessFunction(config, this.o, "f-score", numberOfExamples);
            this.fitness.useFScore();
            Mapping start = ExampleOracleTrimmer.trimExamplesRandomly(this.o.getMapping(), numberOfExamples);
            System.out.println("Start data " + start);
            this.fitness.setReferenceMapping(start);
            this.fitness.trimKnowledgeBases(start);
            config.setFitnessFunction(this.fitness);
            ExpressionProblem gpP = new ExpressionProblem(config);
            GPGenotype gp = gpP.create();
            Clock clock = new Clock();
            ALDecider aLD = new ALDecider();
            for (int inquery = 1; inquery <= inquiries; ++inquery) {
                List<Mapping> mapsOfPop;
                logger.info("Inquery nr " + inquery + " on dataset" + (Object)((Object)data) + " run " + run + "");
                for (int gen = 0; gen < gens; ++gen) {
                    gp.evolve();
                    gp.calcFitness();
                }
                this.examineGen(run, inquery * gens, gp, clock);
                if (inquery == inquiries || (mapsOfPop = this.getMaps(gp.getGPPopulation())).size() <= 0) continue;
                List<Triple> toAsk = aLD.getControversyCandidates(mapsOfPop, numberOfExamples);
                logger.info("Asking about " + toAsk.size() + " instances.");
                if (toAsk.size() == 0) {
                    aLD.maxCount += 100;
                }
                Mapping oracleAnswers = new Mapping();
                for (Triple t : toAsk) {
                    if (!this.o.ask(t.getSourceUri(), t.getTargetUri())) continue;
                    oracleAnswers.add(t.getSourceUri(), t.getTargetUri(), 1.0);
                }
                this.fitness.addToReference(oracleAnswers);
                this.fitness.fillCachesIncrementally(toAsk);
            }
            this.finishRun();
            this.fitness.destroy();
            LinkSpecGeneticLearnerConfig.reset();
        }
        this.finishDataset(1, popSize, gens, this.params);
    }

    private void examineGen(int run, int gen, GPGenotype gp, Clock clock) {
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        double fittest = Double.MAX_VALUE;
        IGPProgram pBest = pop.determineFittestProgram();
        fittest = this.fitness.calculateRawFitness(pBest);
        for (GPProgram p : (GPProgram[])pop.getGPPrograms()) {
            double actFit = this.fitness.calculateRawFitness((IGPProgram)p);
            if (!(fittest > actFit) || this.getMetric((IGPProgram)p).getExpression().indexOf("falseProp") != -1) continue;
            pBest = p;
            fittest = actFit;
            System.out.println("Setting to fitter program then JGAP");
        }
        boolean getBetterOld = false;
        for (EvaluationPseudoMemory mem : this.perRunMemory) {
            double oldFit = this.fitness.calculateRawFitness(mem.program);
            if (!(oldFit < fittest)) continue;
            fittest = oldFit;
            pBest = mem.program;
            getBetterOld = true;
        }
        if (getBetterOld) {
            System.out.println("Reusing older program...");
        }
        EvaluationPseudoMemory mem = new EvaluationPseudoMemory(run, gen, this.getMetric(pBest), fittest, clock.totalDuration());
        mem.knownInstances = this.fitness.getReferenceMapping().size();
        mem.program = pBest;
        this.perRunMemory.add(mem);
    }

    private void finishRun() {
        logger.info("Fininshing run...");
        for (EvaluationPseudoMemory mem : this.perRunMemory) {
            Mapping fullMap = this.fitness.getMapping(mem.metric.getExpression(), mem.metric.getThreshold(), true);
            PRFComputer pRF = new PRFComputer();
            mem.fmeasue = pRF.computeFScore(fullMap, this.o.getMapping());
            mem.recall = pRF.computeRecall(fullMap, this.o.getMapping());
            mem.precision = pRF.computePrecision(fullMap, this.o.getMapping());
        }
        this.perDatasetMemory.addAll(this.perRunMemory);
        this.perRunMemory.clear();
    }

    private void finishDataset(int maxRuns, int popSize, int gens, HashMap<String, Object> params) {
        Collections.sort(this.perDatasetMemory);
        PseudoEvalFileLogger fileLog = new PseudoEvalFileLogger((String)params.get("evalfolder"), (String)params.get("evalfilename"));
        fileLog.nameExtansion = "AL_pop=" + popSize + "_gens=" + gens;
        fileLog.log(this.perDatasetMemory, maxRuns, gens, params);
        this.perDatasetMemory.clear();
    }

    public List<Mapping> getMaps(GPPopulation pop) {
        int i;
        LinkedList<Mapping> allMaps = new LinkedList<Mapping>();
        HashSet<String> expressions = new HashSet<String>();
        LinkedList<IGPProgram> considered = new LinkedList<IGPProgram>();
        int max = pop.size();
        if (this.restrictGetAllMaps) {
            pop.sort((Comparator)new Comparator<IGPProgram>(){

                @Override
                public int compare(IGPProgram o1, IGPProgram o2) {
                    if (o1.getFitnessValue() < o2.getFitnessValue()) {
                        return -1;
                    }
                    if (o1.getFitnessValue() > o2.getFitnessValue()) {
                        return 1;
                    }
                    return 0;
                }
            });
            max = Math.min(this.maxMaps, pop.size());
        }
        for (i = 0; i < max; ++i) {
            considered.add(pop.getGPProgram(i));
        }
        for (i = 0; i < Math.min(pop.size(), 20); ++i) {
            for (IGPProgram gProg : considered) {
                String expr = "falseProp";
                double d = 0.9;
                try {
                    Metric metric = this.getMetric(gProg);
                    expr = metric.getExpression();
                    d = metric.getThreshold();
                }
                catch (IllegalStateException e) {
                    continue;
                }
                if (expr.indexOf("falseProp") > -1) continue;
                if (expressions.contains(expr + d)) {
                    ++this.maxMaps;
                    continue;
                }
                expressions.add(expr + d);
                try {
                    allMaps.add(this.fitness.getMapping(expr, d, true));
                }
                catch (OutOfMemoryError bounded) {
                    logger.info("Encountered Memory error...");
                }
            }
        }
        return allMaps;
    }

    private Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    public void restrictNumberOfMaps(int maximum) {
        if (maximum > 0) {
            this.restrictGetAllMaps = true;
            this.maxMaps = maximum;
        }
    }

    public static void main(String[] args) {
        DataSetChooser.DataSets[] datas = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.DBLPACM, DataSetChooser.DataSets.ABTBUY, DataSetChooser.DataSets.AMAZONGOOGLE, DataSetChooser.DataSets.DBLPSCHOLAR};
        if (args.length > 0) {
            datas = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.AMAZONGOOGLE};
        }
        try {
            for (DataSetChooser.DataSets data : datas) {
                for (int pop : new int[]{20}) {
                    ALEvaluation eval = new ALEvaluation();
                    eval.run(data, pop, 10, 10, 10);
                }
            }
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

