/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.core;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.Filter;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import org.apache.log4j.Logger;
import org.jgap.gp.GPFitnessFunction;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.ProgramChromosome;

public class PseudoFMeasureFitnessFunction
extends GPFitnessFunction {
    private static final long serialVersionUID = -7114137172832439294L;
    static Logger logger = Logger.getLogger((String)"LIMES");
    Cache sourceCache;
    Cache targetCache;
    LinkSpecGeneticLearnerConfig config;
    SetConstraintsMapper mapper;
    PseudoMeasures measure;
    Filter f;
    double beta = 1.0;
    private static PseudoFMeasureFitnessFunction instance = null;

    private PseudoFMeasureFitnessFunction(LinkSpecGeneticLearnerConfig a_config, PseudoMeasures measure, Cache c1, Cache c2) {
        this.config = a_config;
        this.sourceCache = c1;
        this.targetCache = c2;
        this.f = new LinearFilter();
        this.mapper = SetConstraintsMapperFactory.getMapper("simple", a_config.source, a_config.target, this.sourceCache, this.targetCache, this.f, 2);
        this.measure = measure;
    }

    protected double evaluate(IGPProgram program) {
        return this.calculateRawFitness(program);
    }

    public double calculateRawFitness(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = null;
        try {
            pc = p.getChromosome(0);
        }
        catch (NullPointerException e) {
            return 10.0;
        }
        if (pc == null) {
            return 10.0;
        }
        Mapping actualMapping = new Mapping();
        Metric metric = (Metric)pc.getNode(0).execute_object(pc, 0, args);
        String expr = metric.getExpression();
        double accThreshold = metric.getThreshold();
        if (expr.indexOf("falseProp") > -1) {
            return 5.0;
        }
        try {
            actualMapping = this.getMapping(expr, accThreshold);
            if (actualMapping.size() == 0) {
                return 7.0;
            }
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return 8.0;
        }
        double pseudoFMeasure = this.measure.getPseudoFMeasure(this.sourceCache.getAllUris(), this.targetCache.getAllUris(), actualMapping, this.beta);
        if (!(pseudoFMeasure >= 0.0) || !(pseudoFMeasure <= 1.0)) {
            logger.error((Object)"Pseudo Measure was not in [0,1]");
        }
        if (pseudoFMeasure >= 0.0) {
            return Math.abs(1.0 - pseudoFMeasure);
        }
        return Math.abs(pseudoFMeasure) + 1.0;
    }

    public Mapping getMapping(String metric, double threshold) {
        return this.mapper.getLinks(metric, threshold).getBestOneToNMapping();
    }

    public static PseudoFMeasureFitnessFunction getInstance(LinkSpecGeneticLearnerConfig a_config, PseudoMeasures measure, Cache c1, Cache c2) {
        if (instance == null) {
            instance = new PseudoFMeasureFitnessFunction(a_config, measure, c1, c2);
            return instance;
        }
        return instance;
    }

    public void destroy() {
        instance = null;
    }

    public PseudoMeasures getMeasure() {
        return this.measure;
    }

    public void setMeasure(PseudoMeasures measure) {
        this.measure = measure;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }
}

