/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.core;

import java.math.BigDecimal;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.ProgramChromosome;

public class Metric {
    private String expression;
    private double threshold;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        double d;
        BigDecimal bd = new BigDecimal(threshold).setScale(4, 6);
        this.threshold = d = bd.doubleValue();
    }

    public Metric(String expression, double threshold) {
        this.setExpression(expression);
        this.setThreshold(threshold);
    }

    public boolean equals(Object o) {
        if (!o.getClass().getCanonicalName().equals(this.getClass().getCanonicalName())) {
            return false;
        }
        return ((Metric)o).expression.equalsIgnoreCase(this.expression) && ((Metric)o).threshold == this.threshold;
    }

    public boolean isValid() {
        return this.expression.indexOf("falseProp") == -1 && this.expression.length() > 0;
    }

    public String toString() {
        BigDecimal bd = new BigDecimal(this.threshold);
        bd = bd.setScale(4, 6);
        return this.expression + ">=" + bd;
    }

    public int hashCode() {
        return this.expression.hashCode() + (int)(10.0 * this.threshold);
    }

    public static void main(String[] args) {
        String expr = "AND(AND(cosine(x.authors,y.authors)|0.7057014747423743,falseProp)|0.6496907940555052,euclidean(x.year,y.year)|0.80141795589077)|0.6496907940555052 >= 0.39257398117644515";
        Metric m = new Metric(expr, 1.0);
        System.out.println(m.isValid());
    }

    public static Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }
}

