/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.core;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.filter.Filter;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.ExampleOracleTrimmer;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import org.apache.log4j.Logger;
import org.jgap.gp.GPFitnessFunction;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.ProgramChromosome;

public class ExpressionFitnessFunction
extends GPFitnessFunction {
    private static final long serialVersionUID = -6546938780090355359L;
    private static ExpressionFitnessFunction instance = null;
    static Logger logger = Logger.getLogger((String)"LIMES");
    protected LinkSpecGeneticLearnerConfig m_config;
    protected SetConstraintsMapper sCM;
    protected SetConstraintsMapper sCMFull;
    protected Mapping optimalMapping;
    protected Mapping reference;
    private Mapping trainingData;
    protected HybridCache sC;
    protected HybridCache tC;
    protected HybridCache trimmedSourceCache;
    protected HybridCache trimmedTargetCache;
    protected int numberOfExamples = 0;
    Filter f = new LinearFilter();
    private int granualarity = 2;
    protected String measure;
    protected double crossProduct;
    public static final String fScore = "fScore";
    public static final String recall = "recall";
    public static final String precision = "precision";
    public static final String mcc = "MCC";

    protected ExpressionFitnessFunction(LinkSpecGeneticLearnerConfig a_config) {
        this.m_config = a_config;
    }

    private ExpressionFitnessFunction(LinkSpecGeneticLearnerConfig a_config, Oracle o, String measure, int sampleSize) {
        this(a_config, o.getMapping(), measure, sampleSize);
    }

    private ExpressionFitnessFunction(LinkSpecGeneticLearnerConfig a_config, Mapping reference, String measure, int sampleSize) {
        this(a_config);
        this.m_config = a_config;
        this.numberOfExamples = sampleSize;
        this.optimalMapping = reference;
        this.reference = reference;
        this.sC = HybridCache.getData(this.m_config.source);
        this.tC = HybridCache.getData(this.m_config.target);
        this.trimKnowledgeBases(reference);
        this.sCM = SetConstraintsMapperFactory.getMapper("simple", a_config.source, a_config.target, this.trimmedSourceCache, this.trimmedTargetCache, this.f, 2);
        this.sCMFull = SetConstraintsMapperFactory.getMapper("simple", a_config.source, a_config.target, this.sC, this.tC, this.f, 2);
        this.measure = measure;
        this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
        System.gc();
    }

    protected double evaluate(IGPProgram a_subject) {
        return this.calculateRawFitness(a_subject);
    }

    public double calculateRawFitness(IGPProgram p) {
        p.getGPConfiguration().clearStack();
        p.getGPConfiguration().clearMemory();
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        Mapping actualMapping = new Mapping();
        Metric metric = (Metric)pc.getNode(0).execute_object(pc, 0, args);
        String expr = metric.getExpression();
        double accThreshold = metric.getThreshold();
        if (expr.indexOf("falseProp") > -1) {
            return 8.0;
        }
        try {
            actualMapping = this.getMapping(expr, accThreshold, false);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return 8.0;
        }
        double res = this.getMeasure(actualMapping, this.reference, this.crossProduct);
        if (res > 1.0) {
            logger.info((Object)("Error Measure > 1: " + res + ". May want to normalize it?"));
        }
        actualMapping.map.clear();
        actualMapping = null;
        if (Double.isNaN(res)) {
            return 5.0;
        }
        if (res >= 0.0) {
            return Math.abs(1.0 - res);
        }
        return Math.abs(res) + 1.0;
    }

    private double getMeasure(Mapping a_mapping, Mapping reference, double crossProduct) {
        PRFComputer prfC = new PRFComputer();
        if (this.measure.equalsIgnoreCase(precision)) {
            return prfC.computePrecision(a_mapping, reference);
        }
        if (this.measure.equalsIgnoreCase(recall)) {
            return prfC.computeRecall(a_mapping, reference);
        }
        if (this.measure.equalsIgnoreCase(mcc)) {
            return prfC.computeMatthewsCorrelation(a_mapping, reference, crossProduct);
        }
        return prfC.computeFScore(a_mapping, reference);
    }

    public void useRecall() {
        this.measure = recall;
    }

    public void usePrecision() {
        this.measure = precision;
    }

    public void useFScore() {
        this.measure = fScore;
    }

    public void useMCC() {
        this.measure = mcc;
    }

    public static ExpressionFitnessFunction getInstance(LinkSpecGeneticLearnerConfig a_config, Oracle o, String measure, int sampleSize) {
        if (instance == null) {
            instance = new ExpressionFitnessFunction(a_config, o, measure, sampleSize);
        }
        return instance;
    }

    public static ExpressionFitnessFunction getInstance(LinkSpecGeneticLearnerConfig a_config, Mapping reference, String measure, int sampleSize) {
        if (instance == null) {
            instance = new ExpressionFitnessFunction(a_config, reference, measure, sampleSize);
        }
        return instance;
    }

    public HybridCache getSourceCache() {
        return this.sC;
    }

    public HybridCache getTargetCache() {
        return this.tC;
    }

    public void destroy() {
        instance = null;
    }

    public void useMeasure(String name) {
        if (name.equalsIgnoreCase(recall)) {
            this.useRecall();
        } else if (name.equalsIgnoreCase(precision)) {
            this.usePrecision();
        } else {
            this.useFScore();
        }
    }

    public Mapping getMapping(String expression, double accThreshold, boolean full) {
        try {
            if (full) {
                logger.info((Object)("get full Mapping for " + expression + ">=" + accThreshold));
                return this.sCMFull.getLinks(expression, accThreshold);
            }
            return this.sCM.getLinks(expression, accThreshold);
        }
        catch (OutOfMemoryError e) {
            logger.warn((Object)("Out of memory trying to get Map for expression\"" + expression + ">=" + accThreshold + "\"."));
            return new Mapping();
        }
    }

    public void trimKnowledgeBases(Mapping trainingData) {
        this.trainingData = trainingData;
        HybridCache[] trimmed = ExampleOracleTrimmer.processData(this.sC, this.tC, trainingData);
        this.trimmedSourceCache = trimmed[0];
        this.trimmedTargetCache = trimmed[1];
        logger.info((Object)("Trimming to " + trimmed[0].size() + " and " + trimmed[1].size() + " caches."));
        this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
        this.sCM = SetConstraintsMapperFactory.getMapper("simple", this.m_config.source, this.m_config.target, this.trimmedSourceCache, this.trimmedTargetCache, this.f, 2);
    }

    public void setReferenceMapping(Mapping referenceData) {
        this.reference = referenceData;
    }

    public void useFullCaches(boolean value) {
        if (value) {
            this.sCM = SetConstraintsMapperFactory.getMapper("simple", this.m_config.source, this.m_config.target, this.sC, this.tC, this.f, 2);
            this.crossProduct = this.sC.size() * this.tC.size();
        } else {
            this.sCM = SetConstraintsMapperFactory.getMapper("simple", this.m_config.source, this.m_config.target, this.trimmedSourceCache, this.trimmedTargetCache, this.f, 2);
            this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
        }
    }

    public Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    public int getGranualarity() {
        return this.granualarity;
    }

    public void setGranualarity(int granualarity) {
        this.granualarity = granualarity;
    }
}

