/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.core;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALFitnessFunction
extends ExpressionFitnessFunction {
    private static final long serialVersionUID = -7148797234498410940L;
    private static ALFitnessFunction instance = null;

    public ALFitnessFunction(LinkSpecGeneticLearnerConfig a_config, Oracle o, String measure, int sampleSize) {
        super(a_config);
        this.m_config = a_config;
        this.numberOfExamples = sampleSize;
        this.optimalMapping = o.getMapping();
        this.reference = o.getMapping();
        this.sC = HybridCache.getData(a_config.source);
        this.tC = HybridCache.getData(a_config.target);
        if (sampleSize > 0) {
            this.trimmedSourceCache = new HybridCache();
            this.trimmedTargetCache = new HybridCache();
            this.crossProduct = 0.0;
        } else {
            this.trimmedSourceCache = this.sC;
            this.trimmedTargetCache = this.tC;
            this.crossProduct = this.sC.size() * this.tC.size();
        }
        this.sCM = SetConstraintsMapperFactory.getMapper("simple", a_config.source, a_config.target, this.trimmedSourceCache, this.trimmedTargetCache, this.f, 2);
        this.sCMFull = SetConstraintsMapperFactory.getMapper("simple", a_config.source, a_config.target, this.sC, this.tC, this.f, 2);
        this.measure = measure;
        System.gc();
    }

    public static ALFitnessFunction getInstance(LinkSpecGeneticLearnerConfig a_config, Oracle o, String measure, int sampleSize) {
        if (instance == null) {
            instance = new ALFitnessFunction(a_config, o, measure, sampleSize);
        }
        return instance;
    }

    public static ALFitnessFunction getInstance(LinkSpecGeneticLearnerConfig a_config, Oracle o, int sampleSize) {
        return ALFitnessFunction.getInstance(a_config, o, "f-score", sampleSize);
    }

    public void fillCachesIncrementally(List<Triple> controversyMatches) {
        for (Triple t : controversyMatches) {
            if (!this.trimmedSourceCache.containsUri(t.getSourceUri())) {
                logger.info((Object)("Adding instance " + t.getSourceUri() + " to sC"));
                this.trimmedSourceCache.addInstance(this.sC.getInstance(t.getSourceUri()));
            }
            if (this.trimmedTargetCache.containsUri(t.getTargetUri())) continue;
            logger.info((Object)("Adding instance " + t.getTargetUri() + " to tC"));
            this.trimmedTargetCache.addInstance(this.tC.getInstance(t.getTargetUri()));
        }
        this.sCM = SetConstraintsMapperFactory.getMapper("simple", this.m_config.source, this.m_config.target, this.trimmedSourceCache, this.trimmedTargetCache, this.f, 2);
        this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
    }

    public void fillCachesIncrementally(Mapping trainingData) {
        logger.info((Object)("Fill Caches Incrementally with " + trainingData.size() + " instances"));
        for (Map.Entry<String, HashMap<String, Double>> e1 : trainingData.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                logger.info((Object)("Looking for instance " + e1.getKey() + " and " + e2.getKey()));
                if (this.trimmedSourceCache == null) {
                    this.trimmedSourceCache = new HybridCache();
                }
                if (this.trimmedTargetCache == null) {
                    this.trimmedTargetCache = new HybridCache();
                }
                if (!this.trimmedSourceCache.containsUri(e1.getKey())) {
                    this.trimmedSourceCache.addInstance(this.sC.getInstance(e1.getKey()));
                }
                if (this.trimmedTargetCache.containsUri(e2.getKey())) continue;
                this.trimmedTargetCache.addInstance(this.tC.getInstance(e2.getKey()));
            }
        }
        this.sCM = SetConstraintsMapperFactory.getMapper("simple", this.m_config.source, this.m_config.target, this.trimmedSourceCache, this.trimmedTargetCache, this.f, 2);
        this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
    }

    public void addToReference(Mapping m) {
        logger.info((Object)("Filling reference of size " + this.reference.size() + " with " + m.size() + " additional matches."));
        for (Map.Entry<String, HashMap<String, Double>> e1 : m.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                this.reference.add(e1.getKey(), e2.getKey(), 1.0);
            }
        }
        logger.info((Object)("Reference has now " + this.reference.size() + " Matches."));
    }

    public Mapping getReferenceMapping() {
        return this.reference;
    }

    @Override
    public void destroy() {
        instance = null;
    }
}

