/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.core;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.data.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALDecider {
    static Logger logger = Logger.getLogger((String)"LIMES");
    public HashSet<Triple> retrieved = new HashSet();
    public int maxCount = 1000;

    public HashMap<Triple, Integer> getControversyMatches(List<Mapping> mapList) {
        HashMap<Triple, Integer> answer = new HashMap<Triple, Integer>();
        for (Mapping m : mapList) {
            int counter = 0;
            for (String key : m.map.keySet()) {
                if (counter >= this.maxCount) continue;
                for (String value : m.map.get(key).keySet()) {
                    Triple t = new Triple(key, value, 1.0f);
                    if (!this.retrieved.contains(t)) {
                        if (answer.containsKey(t)) {
                            int count = answer.get(t);
                            answer.put(t, count + 1);
                        } else {
                            answer.put(t, 1);
                        }
                    }
                    ++counter;
                }
            }
        }
        return answer;
    }

    public List<Triple> getControversyCandidates(List<Mapping> mapList, int n) {
        logger.info((Object)("get " + n + " most controversy matches from " + mapList.size() + " Mappings"));
        HashMap answer = new HashMap();
        for (int i = 1; i <= mapList.size(); ++i) {
            answer.put(i, new HashSet());
        }
        HashMap<Triple, Integer> sub = this.getControversyMatches(mapList);
        for (Map.Entry e : sub.entrySet()) {
            ((Set)answer.get(e.getValue())).add(e.getKey());
        }
        logger.info((Object)("numbered controversy Matches with " + sub.size() + " triples. Putting them to " + answer.size() + " indices."));
        LinkedList<Triple> tripleList = new LinkedList<Triple>();
        int center = mapList.size() / 2;
        int minDist = mapList.size();
        while (tripleList.size() < Math.min(n, sub.size()) && !answer.isEmpty()) {
            boolean found = false;
            int MapsForFound = 0;
            Iterator<Object> i$ = answer.keySet().iterator();
            while (i$.hasNext()) {
                int d = (Integer)i$.next();
                if (Math.abs(d - center) <= minDist) {
                    minDist = d;
                }
                found = true;
                MapsForFound = d;
            }
            if (found && answer.containsKey(minDist)) {
                for (Triple t : (Set)answer.get(minDist)) {
                    if (tripleList.size() < Math.min(n, sub.size())) {
                        t.setSimilarity((float)MapsForFound / (float)mapList.size());
                        tripleList.add(t);
                        this.retrieved.add(t);
                        continue;
                    }
                    return tripleList;
                }
                answer.remove(minDist);
            }
            center = mapList.size() / 2;
            minDist = mapList.size();
        }
        logger.info((Object)("Controversy matches: " + tripleList));
        if (tripleList.size() == 0) {
            System.exit(1);
        }
        return tripleList;
    }

    public List<Triple> getControversyCandidates(List<Mapping> mapList) {
        HashMap answer = new HashMap();
        for (int i = 1; i <= mapList.size(); ++i) {
            answer.put(i, new HashSet());
        }
        HashMap<Triple, Integer> sub = this.getControversyMatches(mapList);
        for (Map.Entry e : sub.entrySet()) {
            ((Set)answer.get(e.getValue())).add(e.getKey());
        }
        logger.info((Object)("numbered controversy Matches with " + sub.size() + " triples. Putting them to " + answer.size() + " indices."));
        LinkedList<Triple> tripleList = new LinkedList<Triple>();
        int center = mapList.size() / 2;
        int minDist = mapList.size();
        while (tripleList.size() < sub.size() && !answer.isEmpty()) {
            boolean found = false;
            int MapsForFound = 0;
            Iterator<Object> i$ = answer.keySet().iterator();
            while (i$.hasNext()) {
                int d = (Integer)i$.next();
                if (Math.abs(d - center) <= minDist) {
                    minDist = d;
                }
                found = true;
                MapsForFound = d;
            }
            if (found && answer.containsKey(minDist)) {
                for (Triple t : (Set)answer.get(minDist)) {
                    if (tripleList.size() < sub.size()) {
                        t.setSimilarity((float)MapsForFound / (float)mapList.size());
                        tripleList.add(t);
                        continue;
                    }
                    return tripleList;
                }
                answer.remove(minDist);
            }
            center = mapList.size() / 2;
            minDist = mapList.size();
        }
        if (tripleList.size() == 0) {
            System.exit(1);
        }
        return tripleList;
    }

    public static void main(String[] args) {
        Mapping a = new Mapping();
        Mapping b = new Mapping();
        Mapping c = new Mapping();
        Mapping d = new Mapping();
        a.add("a", "y", 1.0);
        a.add("d", "f", 8.0);
        b.add("a", "y", 1.0);
        b.add("a", "x", 4.0);
        c.add("c", "y", 5.0);
        c.add("d", "f", 5.0);
        d.add("D", "D", 77.0);
        d.add("a", "y", 1.0);
        d.add("a", "x", 4.0);
        LinkedList<Mapping> mapList = new LinkedList<Mapping>();
        mapList.add(a);
        mapList.add(b);
        mapList.add(c);
        mapList.add(d);
        ALDecider aLD = new ALDecider();
        HashMap<Triple, Integer> result0 = aLD.getControversyMatches(mapList);
        System.out.println("aLD.getControversyMatches(mapList)\n" + result0);
        List<Triple> result = aLD.getControversyCandidates(mapList, 1);
        System.out.println(result);
        aLD.setKnown(new Mapping());
        aLD.retrieved.clear();
        result = aLD.getControversyCandidates(mapList, 2);
        System.out.println(result);
        result = aLD.getControversyCandidates(mapList, 8);
        System.out.println(result);
    }

    public void setKnown(Mapping m) {
        for (String a : m.map.keySet()) {
            for (String b : m.map.get(a).keySet()) {
                this.retrieved.add(new Triple(a, b, 1.0f));
            }
        }
    }
}

