/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.commands;

import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class NestedBoolean
extends CommandGene
implements IMutateable,
ICloneable {
    private static final long serialVersionUID = 7875735649199172973L;
    static Logger logger = Logger.getLogger((String)"LIMES");
    private String command = "AND";
    private List<String> supportedMetrics;
    boolean is_mutable = true;

    public NestedBoolean(String op, GPConfiguration a_conf) throws InvalidConfigurationException {
        this(op, a_conf, String.class, true);
    }

    public NestedBoolean(String op, GPConfiguration a_conf, Class a_returnType, boolean mutable) throws InvalidConfigurationException {
        super(a_conf, 3, a_returnType, 1, new int[]{1, 1, ExpressionProblem.ResourceTerminalType.THRESHOLD.intValue()});
        this.command = op;
        this.supportedMetrics = new ArrayList<String>();
        this.supportedMetrics.add("AND");
        this.supportedMetrics.add("OR");
        this.supportedMetrics.add("XOR");
        this.is_mutable = mutable;
    }

    public String toString() {
        return this.command + "(&1,&2)|&3";
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0) {
            return String.class;
        }
        if (a_chromNum == 1) {
            return String.class;
        }
        return CommandGene.DoubleClass;
    }

    public Object execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.check(a_chrom, a_n);
        String s1 = (String)a_chrom.execute_object(a_n, 0, args);
        String s2 = (String)a_chrom.execute_object(a_n, 1, args);
        double threshold = a_chrom.execute_double(a_n, 2, args);
        StringBuffer value = new StringBuffer(this.command);
        value.append("(");
        value.append(s1);
        value.append(",");
        value.append(s2);
        value.append(")");
        value.append("|");
        value.append(new BigDecimal(threshold).setScale(4, 6));
        return value.toString();
    }

    public void execute_void(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.execute_object(a_chrom, a_n, args);
    }

    public Object clone() {
        try {
            NestedBoolean result = new NestedBoolean(this.command, this.getGPConfiguration(), this.getReturnType(), this.is_mutable);
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    public CommandGene applyMutation(int a_index, double a_percentage) throws InvalidConfigurationException {
        if (!this.is_mutable) {
            return this;
        }
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        double random = randomGen.nextDouble();
        if (random < a_percentage) {
            return this.applyMutation();
        }
        return this;
    }

    private CommandGene applyMutation() {
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        int index = randomGen.nextInt(this.supportedMetrics.size());
        this.command = this.supportedMetrics.get(index);
        return this;
    }
}

