/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.commands;

import de.uni_leipzig.simba.genetics.commands.AddMetric;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.Metric;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class MetricCommand
extends CommandGene
implements IMutateable,
ICloneable {
    private static final long serialVersionUID = -5555554301086427498L;

    public MetricCommand(GPConfiguration config) throws InvalidConfigurationException {
        this(config, Metric.class);
    }

    public MetricCommand(GPConfiguration config, Class returnType) throws InvalidConfigurationException {
        super(config, 2, returnType, 88, new int[]{1, ExpressionProblem.ResourceTerminalType.GOBALTHRESHOLD.intValue()});
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0) {
            return String.class;
        }
        return CommandGene.DoubleClass;
    }

    public String toString() {
        return "Metric(&1, &2)";
    }

    public CommandGene applyMutation(int a_index, double a_percentage) throws InvalidConfigurationException {
        return this;
    }

    public Object clone() {
        try {
            MetricCommand result = new MetricCommand(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    public Metric execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        String expr = AddMetric.removeThresholdFromMeasure((String)a_chrom.execute_object(a_n, 0, args));
        double thres = a_chrom.execute_double(a_n, 1, args);
        if (expr.startsWith("euclidean") && thres < 0.4) {
            thres = 0.4;
        }
        return new Metric(expr, thres);
    }
}

