/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.filter;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.Filter;
import de.uni_leipzig.simba.mapper.SetOperations;
import de.uni_leipzig.simba.measures.MeasureProcessor;
import org.apache.log4j.Logger;

public class LinearFilter
implements Filter {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public Mapping filter(Mapping map, String condition, double threshold, Cache source, Cache target, String sourceVar, String targetVar) {
        double sim = 0.0;
        if (threshold <= 0.0) {
            return map;
        }
        if (condition == null) {
            return this.filter(map, threshold);
        }
        Mapping result = new Mapping();
        for (String key : map.map.keySet()) {
            Instance s = source.getInstance(key);
            for (String value : map.map.get(key).keySet()) {
                Instance t = target.getInstance(value);
                sim = MeasureProcessor.getSimilarity(s, t, condition, sourceVar, targetVar);
                if (!(sim >= threshold)) continue;
                result.add(s.getUri(), t.getUri(), sim);
            }
        }
        return result;
    }

    public Mapping filter(Mapping map, double threshold) {
        double sim = 0.0;
        if (threshold <= 0.0) {
            return map;
        }
        Mapping result = new Mapping();
        for (String key : map.map.keySet()) {
            for (String value : map.map.get(key).keySet()) {
                sim = map.getSimilarity(key, value);
                if (!(sim >= threshold)) continue;
                result.add(key, value, sim);
            }
        }
        return result;
    }

    public Mapping filter(Mapping m1, Mapping m2, double coef1, double coef2, double threshold, String operation) {
        Mapping m = SetOperations.intersection(m1, m2);
        Mapping result = new Mapping();
        if (operation.equalsIgnoreCase("add")) {
            for (String key : m.map.keySet()) {
                for (String value : m.map.get(key).keySet()) {
                    double sim = coef1 * m1.getSimilarity(key, value) + coef2 * m2.getSimilarity(key, value);
                    if (!(sim >= threshold)) continue;
                    result.add(key, value, sim);
                }
            }
        } else {
            for (String key : m.map.keySet()) {
                for (String value : m.map.get(key).keySet()) {
                    double sim = coef1 * coef2 * m1.getSimilarity(key, value) * m2.getSimilarity(key, value);
                    if (!(sim >= threshold)) continue;
                    result.add(key, value, sim);
                }
            }
        }
        return result;
    }
}

