/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.rewriter;

import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.execution.rewriter.Rewriter;
import de.uni_leipzig.simba.specification.LinkSpec;
import de.uni_leipzig.simba.util.Clock;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.form.output.StringBufferWriter;
import org.matheclipse.core.interfaces.IExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRewriter
implements Rewriter {
    static Logger logger = Logger.getLogger((String)"LIMES");

    @Override
    public LinkSpec rewrite(LinkSpec spec) {
        return spec;
    }

    public static String factorExpression(String metric) {
        try {
            String copy = metric.replaceAll(" ", "");
            if (DefaultRewriter.isBoolean(metric)) {
                ArrayList<String> variables = new ArrayList<String>();
                variables.addAll(DefaultRewriter.getVariables(metric));
                copy = DefaultRewriter.getInfix(copy);
                for (int i = 0; i < variables.size(); ++i) {
                    copy = copy.replaceAll(Pattern.quote((String)variables.get(i)), (char)(65 + i) + "");
                }
                F.initSymbols(null);
                EvalUtilities util = new EvalUtilities();
                String input = "Factor[" + copy + "]";
                input = "Factor[((B+A)*(B+A))]";
                IExpr result = util.evaluate(input);
                StringBufferWriter buf = new StringBufferWriter();
                OutputFormFactory.get().convert((Writer)buf, result);
                copy = buf.toString();
                for (int i = 0; i < variables.size(); ++i) {
                    copy = copy.replaceAll(Pattern.quote((char)(65 + i) + ""), (String)variables.get(i));
                }
                return copy;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("Error factoring expression " + metric));
        }
        return metric;
    }

    public static String getInfix(String metric) {
        try {
            Parser p = new Parser(metric, 1.0);
            if (p.isAtomic()) {
                return metric;
            }
            String operation = p.getOperation();
            String term1 = p.getTerm1();
            String t1 = p.threshold1 + "";
            String term2 = p.getTerm2();
            String t2 = p.threshold2 + "";
            if (operation.equals("MIN") || operation.equals("AND")) {
                return "(" + DefaultRewriter.getInfix(p.getTerm1() + "|" + t1) + "*" + DefaultRewriter.getInfix(p.getTerm2() + "|" + t2) + ")";
            }
            if (operation.equals("MAX") || operation.equals("OR")) {
                return "(" + DefaultRewriter.getInfix(p.getTerm1() + "|" + t1) + "+" + DefaultRewriter.getInfix(p.getTerm2() + "|" + t2) + ")";
            }
            return metric;
        }
        catch (Exception e) {
            logger.warn((Object)("Error parsing " + metric));
            e.printStackTrace();
            return metric;
        }
    }

    public static Set<String> getVariables(String metric) {
        Set<String> result;
        Parser p = new Parser(metric, 1.0);
        if (p.isAtomic()) {
            result = new HashSet<String>();
            result.add(metric);
        } else {
            result = DefaultRewriter.getVariables(p.getTerm1() + "|" + p.threshold1);
            result.addAll(DefaultRewriter.getVariables(p.getTerm2() + "|" + p.threshold2));
        }
        return result;
    }

    public static boolean isBoolean(String metric) {
        Parser p = new Parser(metric, 1.0);
        if (p.isAtomic()) {
            return true;
        }
        String term1 = p.getTerm1();
        String term2 = p.getTerm2();
        if (!p.getOperation().equals("ADD") || !p.getOperation().equals("MULT")) {
            return DefaultRewriter.isBoolean(term1) && DefaultRewriter.isBoolean(term2);
        }
        return false;
    }

    public static void main(String[] args) {
        Clock c = new Clock();
        String metric = "MIN(OR(m1(x.l, y.l)|0.5, m2(x.p, y.p)|0.7), OR(m1(x.l, y.l)|0.5, m2(x.p, y.p)|0.7))";
        System.out.println(DefaultRewriter.isBoolean(metric));
        System.out.println(DefaultRewriter.getInfix(metric));
        System.out.println(DefaultRewriter.factorExpression(metric));
        System.out.println(c.totalDuration());
    }
}

