/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.rewriter;

import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.execution.rewriter.Rewriter;
import de.uni_leipzig.simba.specification.LinkSpec;
import de.uni_leipzig.simba.specification.Operator;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgebraicRewriter
implements Rewriter {
    static Logger logger = Logger.getLogger((String)"LIMES");

    @Override
    public LinkSpec rewrite(LinkSpec spec) {
        int newSize = spec.size();
        int counter = 0;
        LinkSpec result = spec;
        try {
            int oldSize;
            do {
                ++counter;
                oldSize = newSize;
                spec = this.updateThresholds(spec);
                spec = this.computeAllDependencies(spec);
                spec = this.collapseSpec(spec);
                spec = this.removeUnaryOperators(spec);
                newSize = spec.size();
                result = spec;
            } while (newSize < oldSize);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public LinkSpec updateThresholds(LinkSpec spec) {
        if (spec.isEmpty()) {
            return spec;
        }
        if (!spec.isAtomic()) {
            if (spec.filterExpression == null) {
                double min = 1.0;
                for (LinkSpec child : spec.children) {
                    if (!(child.threshold < min)) continue;
                    min = child.threshold;
                }
                if (spec.threshold <= min) {
                    spec.threshold = 0.0;
                }
            }
            for (LinkSpec child : spec.children) {
                LinkSpec linkSpec = this.updateThresholds(child);
            }
        }
        return spec;
    }

    public LinkSpec removeUnaryOperators(LinkSpec spec) {
        if (!spec.isAtomic() && !spec.isEmpty()) {
            if (spec.filterExpression == null && spec.children.size() == 1) {
                double theta = Math.max(spec.threshold, spec.children.get((int)0).threshold);
                System.out.print("Old spec = " + spec + "\t");
                spec = spec.children.get(0);
                spec.threshold = theta;
                System.out.println("New spec = " + spec + "\t");
            }
            if (!spec.isAtomic()) {
                ArrayList<LinkSpec> newChildren = new ArrayList<LinkSpec>();
                for (LinkSpec child : spec.children) {
                    newChildren.add(this.removeUnaryOperators(child));
                }
                spec.children = newChildren;
            }
        }
        return spec;
    }

    public LinkSpec computeAtomicDependency(LinkSpec source, LinkSpec target) {
        String measure2;
        String measure1;
        if (!source.isAtomic() || !target.isAtomic()) {
            return source;
        }
        if (this.getProperties(source).equals(this.getProperties(target)) && (measure1 = this.getMeasure(source)).equals(measure2 = this.getMeasure(target))) {
            if (source.threshold <= target.threshold) {
                source.addDependency(target);
            } else {
                double t1 = source.threshold;
                double t2 = target.threshold;
                if (!measure1.equals("trigrams") && measure2.equals("overlap") && measure2.equals("jaccard") && t2 <= 2.0 * t1 / (1.0 + t1)) {
                    source.addDependency(target);
                }
            }
        }
        return source;
    }

    public List<String> getProperties(LinkSpec spec) {
        ArrayList<String> result = new ArrayList<String>();
        if (spec.isAtomic()) {
            Parser p = new Parser(spec.filterExpression, spec.threshold);
            result.add(p.getTerm1());
            result.add(p.getTerm2());
        }
        return result;
    }

    public String getMeasure(LinkSpec spec) {
        if (spec.isAtomic()) {
            return spec.filterExpression.substring(0, spec.filterExpression.indexOf("("));
        }
        return null;
    }

    public LinkSpec computeAllDependencies(LinkSpec spec) {
        spec = this.computeAtomicDependencies(spec);
        spec = this.computeNonAtomicDependencies(spec);
        return spec;
    }

    public LinkSpec computeNonAtomicDependencies(LinkSpec spec) {
        if (!spec.isAtomic()) {
            List<Object> newDependencies = null;
            ArrayList<LinkSpec> newChildren = new ArrayList<LinkSpec>();
            for (LinkSpec linkSpec : spec.children) {
                newChildren.add(this.computeNonAtomicDependencies(linkSpec));
            }
            spec.children = newChildren;
            if (spec.operator == Operator.AND && spec.children.get(0).hasDependencies()) {
                newDependencies = spec.children.get((int)0).dependencies;
                for (int i = 1; i < spec.children.size() && spec.children.get(i).hasDependencies(); ++i) {
                    newDependencies.retainAll(spec.children.get((int)i).dependencies);
                }
            }
            if (spec.operator == Operator.OR) {
                newDependencies = new ArrayList();
                for (LinkSpec linkSpec : spec.children) {
                    if (!linkSpec.hasDependencies()) continue;
                    newDependencies.addAll(linkSpec.dependencies);
                }
            }
            spec.dependencies = null;
            if (newDependencies != null) {
                for (LinkSpec linkSpec : newDependencies) {
                    if (!(linkSpec.threshold > spec.threshold) && spec.threshold != 0.0) continue;
                    spec.addDependency(linkSpec);
                }
            }
        }
        return spec;
    }

    public LinkSpec computeAtomicDependencies(LinkSpec spec) {
        List<LinkSpec> leaves = spec.getAllLeaves();
        for (int i = 0; i < leaves.size(); ++i) {
            leaves.get((int)i).dependencies = new ArrayList<LinkSpec>();
            for (int j = 0; j < leaves.size(); ++j) {
                if (i == j) continue;
                leaves.set(i, this.computeAtomicDependency(leaves.get(i), leaves.get(j)));
            }
        }
        return spec;
    }

    public LinkSpec collapseSpec(LinkSpec spec) {
        ArrayList<LinkSpec> newChildren;
        if (spec.isAtomic() || spec.isEmpty()) {
            return spec;
        }
        if (spec.operator == Operator.AND) {
            newChildren = new ArrayList<LinkSpec>();
            newChildren.addAll(spec.children);
            for (LinkSpec child : spec.children) {
                if (!child.hasDependencies()) continue;
                for (LinkSpec dependency : child.dependencies) {
                    if (!newChildren.contains(dependency) || newChildren.size() <= 1) continue;
                    newChildren.remove(child);
                }
            }
            spec.children = newChildren;
        } else if (spec.operator == Operator.OR) {
            newChildren = new ArrayList();
            newChildren.addAll(spec.children);
            for (LinkSpec child : spec.children) {
                if (!child.hasDependencies()) continue;
                for (LinkSpec dependency : child.dependencies) {
                    if (!newChildren.contains(dependency) || newChildren.size() <= 1) continue;
                    newChildren.remove(dependency);
                }
            }
            spec.children = newChildren;
        }
        newChildren = new ArrayList();
        for (LinkSpec child : spec.children) {
            newChildren.add(this.collapseSpec(child));
        }
        spec.children = newChildren;
        return spec;
    }

    public static void main(String[] args) {
        AlgebraicRewriter.rewriteTest();
    }

    public static void updateThresholdsTest() {
        AlgebraicRewriter ar = new AlgebraicRewriter();
        LinkSpec spec = new LinkSpec();
        LinkSpec spec2 = new LinkSpec();
        spec.readSpec("AND(trigrams(x.p, y.p)|0.6, AND(euclidean(x.q, y.q)|0.7, linear(x.s, y.s)|0.7)|0.6)", 0.5);
        spec2.readSpec("AND(euclidean(x.q, y.q)|0.7, linear(x.s, y.s)|0.7)", 0.7);
        System.out.println(spec + "\n" + spec2);
        System.out.println(ar.updateThresholds(spec));
        System.out.println(ar.updateThresholds(spec2));
        System.out.println(spec);
        System.out.println(spec2);
    }

    public static void rewriteTest() {
        LinkSpec spec = new LinkSpec();
        spec.readSpec("AND(XOR(levenshtein(x.authors,y.authors)|0.9135,XOR(cosine(x.venue,y.venue)|0.5183,overlap(x.title,y.title)|0.5183)|0.4506)|0.4506,AND(XOR(overlap(x.authors,y.authors)|0.4506,OR(levenshtein(x.authors,y.authors)|0.4506,euclidean(x.year,y.year)|0.9304)|0.5558)|0.0073,overlap(x.title,y.title)|0.7019)|0.7019)", 0.5);
        AlgebraicRewriter ar = new AlgebraicRewriter();
        spec = ar.rewrite(spec);
        System.out.println(spec);
    }

    public static void dependencyTest() {
        AlgebraicRewriter ar = new AlgebraicRewriter();
        LinkSpec spec = new LinkSpec();
        spec.readSpec("jaccard(x.q, y.q)", 0.5);
        LinkSpec spec2 = new LinkSpec();
        spec2.readSpec("jaccard(x.q, y.o)", 0.7);
        spec.readSpec("OR(jaccard(x.q, y.q)|0.75, AND(jaccard(x.q, y.q)|0.7, jaccard(x.q, y.q)|0.5)|0.8)", 0.5);
        spec = ar.computeAllDependencies(spec);
        System.out.println(spec);
        spec = ar.collapseSpec(spec);
        System.out.println(spec);
        spec = ar.removeUnaryOperators(spec);
        System.out.println(spec);
        spec = ar.updateThresholds(spec);
        spec = ar.removeUnaryOperators(spec);
        System.out.println(spec);
    }

    public static void unaryTest() {
        AlgebraicRewriter ar = new AlgebraicRewriter();
        LinkSpec spec = new LinkSpec();
        LinkSpec spec2 = new LinkSpec();
        LinkSpec spec3 = new LinkSpec();
        spec.readSpec("trigrams(x.p, y.p)", 0.7);
        spec2.readSpec("euclidean(x.q, y.q)", 0.3);
        spec3.threshold = 0.5;
        spec3.operator = Operator.AND;
        spec.addChild(spec3);
        spec3.addChild(spec2);
        System.out.println(spec);
        spec = ar.removeUnaryOperators(spec);
        System.out.println(spec);
    }
}

