/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.planner;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.ExecutionEngine;
import de.uni_leipzig.simba.execution.NestedPlan;
import de.uni_leipzig.simba.execution.planner.CanonicalPlanner;
import de.uni_leipzig.simba.execution.planner.HeliosPlanner;
import de.uni_leipzig.simba.execution.rewriter.AlgebraicRewriter;
import de.uni_leipzig.simba.mapper.SetOperations;
import de.uni_leipzig.simba.selfconfig.Experiment;
import de.uni_leipzig.simba.specification.LinkSpec;

public class PlannerTest {
    public static void test() {
        CanonicalPlanner cp = new CanonicalPlanner();
        Cache source = Experiment.readFile("E:/Work/Data/Datenbanken/DBLP-Scholar/DBLP.csv");
        Cache target = Experiment.readFile("E:/Work/Data/Datenbanken/DBLP-Scholar/Scholar.csv");
        HeliosPlanner hp = new HeliosPlanner(source, target);
        LinkSpec spec = new LinkSpec();
        spec.readSpec("AND(jaccard(x.authors,y.authors)|0.4278,overlap(x.authors,y.authors)|0.4278)", 0.36);
        System.out.println("Orginal: " + spec);
        AlgebraicRewriter rewriter = new AlgebraicRewriter();
        spec = rewriter.rewrite(spec);
        System.out.println("Rewritten: " + spec);
        System.out.println("Canonical plan:\n" + cp.plan(spec));
        cp.plan(spec).draw();
        NestedPlan np = hp.plan(spec);
        np.draw();
        System.out.println("HELIOS plan:\n" + np);
        ExecutionEngine ee = new ExecutionEngine(source, source, "?x", "?y");
        long begin = System.currentTimeMillis();
        Mapping m1 = ee.runNestedPlan(np);
        long end = System.currentTimeMillis();
        System.out.println(end - begin + " ms for HELIOS, " + m1.getNumberofMappings() + " results.");
        begin = System.currentTimeMillis();
        Mapping m2 = ee.runNestedPlan(cp.plan(spec));
        end = System.currentTimeMillis();
        System.out.println(end - begin + " ms for CANONICAL, " + m2.getNumberofMappings() + " results.");
        System.out.println(SetOperations.difference(m1, m2).getNumberofMappings() + " are missing somewhere");
        System.out.println(SetOperations.difference(m2, m1).getNumberofMappings() + " are missing somewhere");
    }

    public static void main(String[] args) {
        PlannerTest.test();
    }
}

