/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.planner;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.Instruction;
import de.uni_leipzig.simba.execution.NestedPlan;
import de.uni_leipzig.simba.execution.planner.ExecutionPlanner;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.atomic.EDJoin;
import de.uni_leipzig.simba.mapper.atomic.PPJoinMapper;
import de.uni_leipzig.simba.mapper.atomic.TotalOrderBlockingMapper;
import de.uni_leipzig.simba.mapper.atomic.fastngram.FastNGram;
import de.uni_leipzig.simba.measures.Measure;
import de.uni_leipzig.simba.measures.MeasureFactory;
import de.uni_leipzig.simba.measures.MeasureProcessor;
import de.uni_leipzig.simba.specification.LinkSpec;
import de.uni_leipzig.simba.specification.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeliosPlanner
implements ExecutionPlanner {
    static Logger logger = Logger.getLogger((String)"LIMES");
    public Cache source;
    public Cache target;
    Map<String, Double> averageSourcePropertyLength;
    Map<String, Double> stdDevSourceProperty;
    Map<String, Double> averageTargetPropertyLength;
    Map<String, Double> stdDevTargetProperty;
    public AtomicMapper.Language lang;

    public HeliosPlanner(Cache s, Cache t) {
        this.source = s;
        this.target = t;
        this.lang = AtomicMapper.Language.NULL;
    }

    public double getAtomicRuntimeCosts(String measure, double threshold) {
        Measure m = MeasureFactory.getMeasure(measure);
        double runtime = m.getName().equalsIgnoreCase("levenshtein") ? new EDJoin().getRuntimeApproximation(this.source.size(), this.target.size(), threshold, this.lang) : (m.getName().equalsIgnoreCase("euclidean") ? new TotalOrderBlockingMapper().getRuntimeApproximation(this.source.size(), this.target.size(), threshold, this.lang) : (m.getName().equalsIgnoreCase("qgrams") ? new FastNGram().getRuntimeApproximation(this.source.size(), this.target.size(), threshold, this.lang) : new PPJoinMapper().getRuntimeApproximation(this.source.size(), this.target.size(), threshold, this.lang)));
        logger.info((Object)("Runtime approximation for " + measure + " is " + runtime));
        return runtime;
    }

    public double getAtomicMappingSizes(String measure, double threshold) {
        double d;
        Measure m = MeasureFactory.getMeasure(measure);
        if (m.getName().equalsIgnoreCase("levenshtein")) {
            d = new EDJoin().getMappingSizeApproximation(this.source.size(), this.target.size(), threshold, this.lang);
        }
        if (m.getName().equalsIgnoreCase("euclidean")) {
            d = new TotalOrderBlockingMapper().getMappingSizeApproximation(this.source.size(), this.target.size(), threshold, this.lang);
        }
        double size = m.getName().equalsIgnoreCase("qgrams") ? new FastNGram().getMappingSizeApproximation(this.source.size(), this.target.size(), threshold, this.lang) : new PPJoinMapper().getMappingSizeApproximation(this.source.size(), this.target.size(), threshold, this.lang);
        return size;
    }

    public double getFilterCosts(List<String> measures, int mappingSize) {
        double cost = 0.0;
        for (String measure : measures) {
            cost += MeasureFactory.getMeasure(measure).getRuntimeApproximation(mappingSize);
        }
        logger.info((Object)("Runtime approximation for filter expression " + measures + " is " + cost));
        return cost;
    }

    @Override
    public NestedPlan plan(LinkSpec spec) {
        return this.plan(spec, this.source, this.target, new Mapping(), new Mapping());
    }

    public NestedPlan plan(LinkSpec spec, Cache source, Cache target, Mapping sourceMapping, Mapping targetMapping) {
        NestedPlan plan = new NestedPlan();
        if (spec.isAtomic()) {
            Parser p = new Parser(spec.filterExpression, spec.threshold);
            plan.instructionList = new ArrayList();
            plan.addInstruction(new Instruction(Instruction.Command.RUN, spec.filterExpression, spec.threshold + "", -1, -1, 0));
            plan.runtimeCost = this.getAtomicRuntimeCosts(p.getOperation(), spec.threshold);
            plan.mappingSize = this.getAtomicMappingSizes(p.getOperation(), spec.threshold);
            plan.selectivity = plan.mappingSize / (double)(source.size() * target.size());
        } else if (!spec.operator.equals((Object)Operator.AND)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            plan.runtimeCost = 0.0;
            for (LinkSpec child : spec.children) {
                NestedPlan childPlan = this.plan(child, source, target, sourceMapping, targetMapping);
                children.add(childPlan);
                plan.runtimeCost += childPlan.runtimeCost;
            }
            plan.runtimeCost += (double)(spec.children.size() - 1);
            plan.subPlans = children;
            if (spec.operator.equals((Object)Operator.OR)) {
                plan.operator = Instruction.Command.UNION;
                double selectivity = 1.0 - ((NestedPlan)children.get((int)0)).selectivity;
                plan.runtimeCost = ((NestedPlan)children.get((int)0)).runtimeCost;
                for (int i = 1; i < children.size(); ++i) {
                    selectivity *= 1.0 - ((NestedPlan)children.get((int)i)).selectivity;
                    if (plan.filteringInstruction == null) continue;
                    plan.runtimeCost += MeasureProcessor.getCosts(plan.filteringInstruction.getMeasureExpression(), (double)(source.size() * target.size()) * (1.0 - selectivity));
                }
                plan.selectivity = 1.0 - selectivity;
            } else if (spec.operator.equals((Object)Operator.MINUS)) {
                plan.operator = Instruction.Command.DIFF;
                double selectivity = ((NestedPlan)children.get((int)0)).selectivity;
                for (int i = 1; i < children.size(); ++i) {
                    selectivity *= 1.0 - ((NestedPlan)children.get((int)i)).selectivity;
                    if (plan.filteringInstruction == null) continue;
                    plan.runtimeCost += MeasureProcessor.getCosts(plan.filteringInstruction.getMeasureExpression(), (double)(source.size() * target.size()) * (1.0 - selectivity));
                }
                plan.selectivity = selectivity;
            } else if (spec.operator.equals((Object)Operator.XOR)) {
                plan.operator = Instruction.Command.XOR;
                double selectivity = ((NestedPlan)children.get((int)0)).selectivity;
                for (int i = 1; i < children.size(); ++i) {
                    selectivity = (1.0 - (1.0 - selectivity) * (1.0 - ((NestedPlan)children.get((int)i)).selectivity)) * (1.0 - selectivity * ((NestedPlan)children.get((int)i)).selectivity);
                    if (plan.filteringInstruction == null) continue;
                    plan.runtimeCost += MeasureProcessor.getCosts(plan.filteringInstruction.getMeasureExpression(), (double)(source.size() * target.size()) * selectivity);
                }
                plan.selectivity = selectivity;
            }
            plan.filteringInstruction = new Instruction(Instruction.Command.FILTER, spec.filterExpression, spec.threshold + "", -1, -1, 0);
        } else if (spec.operator.equals((Object)Operator.AND)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            plan.runtimeCost = 0.0;
            double selectivity = 1.0;
            for (LinkSpec child : spec.children) {
                NestedPlan childPlan = this.plan(child);
                children.add(childPlan);
                plan.runtimeCost += childPlan.runtimeCost;
                selectivity *= childPlan.selectivity;
            }
            plan = this.getBestConjunctivePlan(children, selectivity);
        }
        return plan;
    }

    public NestedPlan getBestConjunctivePlan(List<NestedPlan> plans, double selectivity) {
        if (plans == null) {
            return null;
        }
        if (plans.isEmpty()) {
            return new NestedPlan();
        }
        if (plans.size() == 1) {
            return plans.get(0);
        }
        if (plans.size() == 2) {
            return this.getBestConjunctivePlan(plans.get(0), plans.get(1), selectivity);
        }
        NestedPlan left = plans.get(0);
        plans.remove(plans.get(0));
        return this.getBestConjunctivePlan(left, plans, selectivity);
    }

    public NestedPlan getBestConjunctivePlan(NestedPlan left, List<NestedPlan> plans, double selectivity) {
        if (plans == null) {
            return left;
        }
        if (plans.isEmpty()) {
            return left;
        }
        if (plans.size() == 1) {
            return this.getBestConjunctivePlan(left, plans.get(0), selectivity);
        }
        NestedPlan right = this.getBestConjunctivePlan(plans, selectivity);
        return this.getBestConjunctivePlan(left, right, selectivity);
    }

    public NestedPlan getBestConjunctivePlan(NestedPlan left, NestedPlan right, double selectivity) {
        double runtime1 = 0.0;
        NestedPlan result = new NestedPlan();
        double mappingSize = (double)(this.source.size() * this.target.size()) * right.selectivity;
        runtime1 = left.runtimeCost + right.runtimeCost;
        double runtime2 = left.runtimeCost;
        runtime2 += this.getFilterCosts(right.getAllMeasures(), (int)Math.ceil(mappingSize));
        double runtime3 = right.runtimeCost;
        mappingSize = (double)(this.source.size() * this.target.size()) * left.selectivity;
        double min = Math.min(Math.min(runtime3 += this.getFilterCosts(left.getAllMeasures(), (int)Math.ceil(mappingSize)), runtime2), runtime1);
        if (min == runtime1) {
            result.operator = Instruction.Command.INTERSECTION;
            result.filteringInstruction = null;
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(left);
            plans.add(right);
            result.subPlans = plans;
        } else if (min == runtime2) {
            result.filteringInstruction = right.isAtomic() ? new Instruction(Instruction.Command.FILTER, right.getEquivalentMeasure(), right.getInstructionList().get(0).getThreshold() + "", -1, -1, 0) : new Instruction(Instruction.Command.FILTER, right.getEquivalentMeasure(), right.filteringInstruction.getThreshold() + "", -1, -1, 0);
            result.operator = null;
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(left);
            result.subPlans = plans;
        } else {
            result.filteringInstruction = left.isAtomic() ? new Instruction(Instruction.Command.FILTER, left.getEquivalentMeasure(), left.getInstructionList().get(0).getThreshold() + "", -1, -1, 0) : new Instruction(Instruction.Command.FILTER, left.getEquivalentMeasure(), left.filteringInstruction.getThreshold() + "", -1, -1, 0);
            result.operator = null;
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(right);
            result.subPlans = plans;
        }
        result.runtimeCost = min;
        result.selectivity = selectivity;
        result.mappingSize = (double)(this.source.size() * this.target.size()) * selectivity;
        return result;
    }
}

