/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.planner;

import de.uni_leipzig.simba.execution.Instruction;
import de.uni_leipzig.simba.execution.NestedPlan;
import de.uni_leipzig.simba.execution.planner.ExecutionPlanner;
import de.uni_leipzig.simba.specification.LinkSpec;
import de.uni_leipzig.simba.specification.Operator;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CanonicalPlanner
implements ExecutionPlanner {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public NestedPlan plan(LinkSpec spec) {
        NestedPlan plan = new NestedPlan();
        if (spec.isAtomic()) {
            plan.instructionList = new ArrayList();
            plan.addInstruction(new Instruction(Instruction.Command.RUN, spec.filterExpression, spec.threshold + "", -1, -1, 0));
        } else {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            for (LinkSpec child : spec.children) {
                children.add(this.plan(child));
            }
            plan.subPlans = children;
            if (spec.operator.equals((Object)Operator.AND)) {
                plan.operator = Instruction.Command.INTERSECTION;
            } else if (spec.operator.equals((Object)Operator.OR)) {
                plan.operator = Instruction.Command.UNION;
            } else if (spec.operator.equals((Object)Operator.XOR)) {
                plan.operator = Instruction.Command.XOR;
            }
            plan.filteringInstruction = new Instruction(Instruction.Command.FILTER, spec.filterExpression, spec.threshold + "", -1, -1, 0);
        }
        return plan;
    }
}

