/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.histogram;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.execution.histogram.DataGenerator;
import de.uni_leipzig.simba.util.Utils;
import java.util.ArrayList;

public class RandomStringGenerator
implements DataGenerator {
    int minLength;
    int maxLength;
    double mean = 0.0;
    double stdDev = 0.0;

    public RandomStringGenerator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public Cache generateData(int size) {
        MemoryCache c = new MemoryCache();
        ArrayList<Double> lengths = new ArrayList<Double>();
        while (c.size() < size) {
            String s = this.generateString();
            lengths.add(Double.valueOf(s.length()));
            c.addTriple(s, "label", s);
        }
        this.stdDev = Utils.getStandardDeviation(lengths);
        this.mean = Utils.getMean(lengths);
        return c;
    }

    public String generateString() {
        String s = "";
        int length = this.minLength + (int)(Math.random() * (double)(this.maxLength - this.minLength));
        for (int j = 0; j < length; ++j) {
            s = s + (char)(97.0 + 26.0 * Math.random());
        }
        return s;
    }

    public String getName() {
        return "randomString";
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.stdDev;
    }
}

