/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.histogram;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.execution.histogram.DataGenerator;
import de.uni_leipzig.simba.util.Utils;
import java.util.ArrayList;

public class RandomNumberGenerator
implements DataGenerator {
    int minimum;
    int maximum;
    double mean = 0.0;
    double stdDev = 0.0;

    public RandomNumberGenerator(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public Cache generateData(int size) {
        MemoryCache c = new MemoryCache();
        ArrayList<Double> values = new ArrayList<Double>();
        while (c.size() < size) {
            double number = (double)this.minimum + Math.random() * (double)(this.maximum - this.minimum);
            values.add(number);
            c.addTriple(number + "", "label", number + "");
        }
        this.stdDev = Utils.getStandardDeviation(values);
        this.mean = Utils.getMean(values);
        return c;
    }

    public String getName() {
        return "randomNumber";
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.stdDev;
    }
}

