/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.histogram;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.execution.histogram.DataGenerator;
import de.uni_leipzig.simba.util.Utils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpBasedGenerator
implements DataGenerator {
    List<String> data;
    Logger logger = Logger.getLogger((String)"LIMES");
    double mean = 0.0;
    double stdDev = 0.0;

    public DumpBasedGenerator(String dump) {
        Model model = ModelFactory.createDefaultModel();
        try {
            RDFReader r = model.getReader("N3");
            FileInputStream in = new FileInputStream(dump);
            r.read(model, (InputStream)in, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.data = this.readLabels(model);
    }

    public List<String> readLabels(Model model) {
        ArrayList<String> labels = new ArrayList<String>();
        try {
            String query = "SELECT ?s WHERE { ?x <" + RDFS.label.getURI() + "> ?s }";
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                labels.add(soln.get("s").asNode().getLiteral().getLexicalForm());
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error while processing classes");
        }
        return labels;
    }

    @Override
    public Cache generateData(int size) {
        MemoryCache c = new MemoryCache();
        ArrayList<Double> lengths = new ArrayList<Double>();
        if (!this.data.isEmpty()) {
            while (c.size() < size) {
                int index = (int)Math.floor(Math.random() * (double)(this.data.size() - 1));
                lengths.add(new Double(this.data.get(index).length()));
                c.addTriple(this.data.get(index), "label", this.data.get(index));
            }
        }
        this.stdDev = Utils.getStandardDeviation(lengths);
        this.mean = Utils.getMean(lengths);
        return c;
    }

    @Override
    public String getName() {
        return "dumpBased";
    }

    public static void main(String[] args) {
        DumpBasedGenerator dbg = new DumpBasedGenerator("E:/Work/Papers/Eigene/2012/ISWC_HELIOS/Data/labels_en_uris_fr.nt");
        long memory = Runtime.getRuntime().totalMemory();
        memory = Runtime.getRuntime().totalMemory() - memory;
        System.out.println(dbg.generateData(10));
        System.out.println(memory / 0x100000L);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getStandardDeviation() {
        return this.stdDev;
    }
}

