/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.evaluation;

import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.view.mxGraph;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.ExecutionEngine;
import de.uni_leipzig.simba.execution.NestedPlan;
import de.uni_leipzig.simba.execution.planner.CanonicalPlanner;
import de.uni_leipzig.simba.execution.planner.ExecutionPlanner;
import de.uni_leipzig.simba.execution.planner.HeliosPlanner;
import de.uni_leipzig.simba.execution.rewriter.AlgebraicRewriter;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.specification.LinkSpec;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experiment {
    static Logger logger = Logger.getLogger((String)"LIMES");
    Cache source;
    Cache target;
    ConfigReader cr;
    ExecutionEngine ee;
    LinkSpec spec;
    Mapping cMapping;
    Mapping hMapping;

    public void init(String configFile) {
        long startTime = System.currentTimeMillis();
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.removeAllAppenders();
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        logger.setLevel(Level.DEBUG);
        this.cr = new ConfigReader();
        this.cr.validateAndRead(configFile);
        logger.info((Object)this.cr.getSourceInfo());
        logger.info((Object)this.cr.getTargetInfo());
        logger.info((Object)"Loading source data ...");
        this.source = HybridCache.getData(this.cr.getSourceInfo());
        logger.info((Object)"Loading target data ...");
        this.target = HybridCache.getData(this.cr.getTargetInfo());
        this.spec = new LinkSpec();
        this.spec.readSpec(this.cr.metricExpression, this.cr.verificationThreshold);
        this.ee = new ExecutionEngine(this.source, this.target, this.cr.sourceInfo.var, this.cr.targetInfo.var);
    }

    public List<Long> runExperiment(String planner, boolean rewrite, int iterations, String rootNameForPictures) {
        Mapping m = new Mapping();
        long duration = Long.MAX_VALUE;
        for (int i = 0; i < iterations; ++i) {
            long begin = System.currentTimeMillis();
            ExecutionPlanner p = planner.startsWith("c") ? new CanonicalPlanner() : new HeliosPlanner(this.source, this.target);
            if (rewrite) {
                AlgebraicRewriter rewriter = new AlgebraicRewriter();
                this.spec = rewriter.rewrite(this.spec);
            }
            NestedPlan np = p.plan(this.spec);
            m = this.ee.runNestedPlan(np);
            if (p instanceof CanonicalPlanner) {
                this.cMapping = m;
            } else {
                this.hMapping = m;
            }
            long end = System.currentTimeMillis();
            duration = Math.min(duration, end - begin);
            try {
                BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)np.getGraph(), null, (double)1.0, (Color)Color.white, (boolean)true, null);
                ImageIO.write((RenderedImage)image, "png", new File(rootNameForPictures + "_planner_" + planner + "_rewrite_" + rewrite + ".png"));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info((Object)("Was unable to draw for " + planner + " planner with rewrite = " + rewrite));
            }
        }
        ArrayList<Long> result = new ArrayList<Long>();
        result.add(duration);
        result.add(Long.valueOf(m.getNumberofMappings()));
        return result;
    }

    public static Map<String, List> runAllConfigs(String configFile, int iterations) {
        Experiment exp = new Experiment();
        exp.init(configFile);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("File", new ArrayList<String>(Arrays.asList(configFile)));
        result.put("SourceSize", new ArrayList<Long>(Arrays.asList(exp.source.size())));
        result.put("TargetSize", new ArrayList<Long>(Arrays.asList(exp.target.size())));
        result.put("C", exp.runExperiment("canonical", false, iterations, configFile));
        result.put("C+HR", exp.runExperiment("canonical", true, iterations, configFile));
        result.put("HP", exp.runExperiment("helios", false, iterations, configFile));
        result.put("HP+HR", exp.runExperiment("helios", true, iterations, configFile));
        result.put("Size", new ArrayList<String>(Arrays.asList(exp.spec.size() + "")));
        return result;
    }

    public static void runAllConfigsOnFolder(String folder, int iterations) {
        ArrayList<Map<String, List>> results = new ArrayList<Map<String, List>>();
        File f = new File(folder);
        if (f.isDirectory()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                File f2 = new File(folder + "/" + files[i]);
                if (!f2.isDirectory() || !new File(f2 + "/spec.xml").exists()) continue;
                try {
                    Map<String, List> map = Experiment.runAllConfigs(folder + "/" + files[i] + "/spec.xml", iterations);
                    results.add(map);
                    logger.info((Object)("Adding " + map));
                    continue;
                }
                catch (Exception exception) {
                    logger.warn((Object)("Could not run " + files[i]));
                }
            }
        }
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/results_helios.csv")));
            if (!results.isEmpty()) {
                ArrayList keys = new ArrayList(((Map)results.get(0)).keySet());
                for (String string : keys) {
                    writer.print(string + "\t");
                }
                writer.println();
                for (Map map : results) {
                    for (String key : keys) {
                        writer.print(((List)map.get(key)).get(0) + "\t");
                    }
                    writer.println();
                }
            }
            writer.close();
        }
        catch (Exception e) {
            logger.warn((Object)("Error writing the following results\n\n " + results));
        }
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("Running " + args[1] + " iterations on all specs in folder " + args[0]);
            Experiment.runAllConfigsOnFolder(args[0], Integer.parseInt(args[1]));
        } else {
            System.out.println(Experiment.runAllConfigs("E:/Work/Java/TransferLearning/finalSpecs/climb-linkedgeodata-venues-mountains/spec.xml", 1));
        }
    }
}

