/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.evaluation;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.ExecutionEngine;
import de.uni_leipzig.simba.execution.NestedPlan;
import de.uni_leipzig.simba.execution.planner.CanonicalPlanner;
import de.uni_leipzig.simba.execution.planner.ExecutionPlanner;
import de.uni_leipzig.simba.execution.planner.HeliosPlanner;
import de.uni_leipzig.simba.execution.rewriter.AlgebraicRewriter;
import de.uni_leipzig.simba.selfconfig.Experiment;
import de.uni_leipzig.simba.specification.LinkSpec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticExperiments {
    public List<String> specifications;
    Cache source;
    Cache target;
    ExecutionEngine ee;
    static Logger logger = Logger.getLogger((String)"LIMES");

    public AutomaticExperiments(String sourceFile, String targetFile, String specFile) {
        this.source = Experiment.readFile(sourceFile);
        this.target = Experiment.readFile(targetFile);
        this.specifications = this.readSpecFile(specFile);
        this.ee = new ExecutionEngine(this.source, this.target, "?x", "?y");
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, specFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.removeAllAppenders();
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        logger.setLevel(Level.DEBUG);
        logger.info((Object)("Running on " + this.specifications.size() + " specs"));
    }

    public List<String> readSpecFile(String specFile) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(specFile), "UTF8"));
            String s = reader.readLine();
            while (s != null) {
                if (s.contains(">=")) {
                    result.add(s);
                }
                s = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void runAllConfigs(String outputFile, int iterations) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            writer.println("CP\tRW+CP\tHP\tRW+HP\tSize");
            LinkSpec specification = new LinkSpec();
            for (String spec : this.specifications) {
                logger.info((Object)("Running spec " + spec));
                specification.readSpec(spec, 0.0);
                try {
                    List<Long> cp = this.runExperiment("c", false, spec, iterations);
                    List<Long> cpr = this.runExperiment("c", true, spec, iterations);
                    List<Long> hp = this.runExperiment("h", false, spec, iterations);
                    List<Long> hpr = this.runExperiment("h", true, spec, iterations);
                    writer.println(cp.get(0) + "\t" + cpr.get(0) + "\t" + hp.get(0) + "\t" + hpr.get(0) + "\t" + specification.size());
                    writer.flush();
                }
                catch (Exception e) {
                    logger.info((Object)("Error running " + spec));
                    e.printStackTrace();
                }
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Long> runExperiment(String planner, boolean rewrite, String specification, int iterations) {
        Mapping m = new Mapping();
        LinkSpec spec = new LinkSpec();
        spec.readSpec(specification.split(Pattern.quote(">="))[0], Double.parseDouble(specification.split(Pattern.quote(">="))[1]));
        long duration = Long.MAX_VALUE;
        for (int i = 0; i < iterations; ++i) {
            ExecutionPlanner p = planner.startsWith("c") ? new CanonicalPlanner() : new HeliosPlanner(this.source, this.target);
            AlgebraicRewriter rewriter = new AlgebraicRewriter();
            long begin = System.currentTimeMillis();
            if (rewrite) {
                spec = rewriter.rewrite(spec);
            }
            NestedPlan np = p.plan(spec);
            m = this.ee.runNestedPlan(np);
            if (p instanceof CanonicalPlanner) {
                Mapping cMapping = m;
            } else {
                Mapping mapping = m;
            }
            long end = System.currentTimeMillis();
            duration = Math.min(duration, end - begin);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        result.add(duration);
        result.add(Long.valueOf(m.getNumberofMappings()));
        return result;
    }

    public static void main(String[] args) {
        AutomaticExperiments exp = new AutomaticExperiments("datasets/restaurant1.csv", "datasets/restaurant2.csv", "datasets/restaurant.txt");
        exp.runAllConfigs("datasets/restaurant_results.txt", 10);
    }
}

