/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.costs;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.SetOperations;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorHistogram {
    int minSize;
    int maxSize;
    int iterations;
    List<Integer> mappingSizes;
    SetOperations.Operator operator;

    public OperatorHistogram(List<Integer> mappingSizes, int minStringSize, int maxStringSize, int iterations, SetOperations.Operator op) {
        this.minSize = minStringSize;
        this.maxSize = maxStringSize;
        this.iterations = iterations;
        this.mappingSizes = mappingSizes;
        this.operator = op;
    }

    public void computeHistogram() {
        for (int sourceSize : this.mappingSizes) {
            for (int targetSize : this.mappingSizes) {
                for (int i = 0; i < this.iterations; ++i) {
                    Mapping m1 = Mapping.generateRandomMapping(sourceSize, this.minSize, this.maxSize);
                    Mapping m2 = Mapping.generateRandomMapping(targetSize, this.minSize, this.maxSize);
                    long memory = Runtime.getRuntime().totalMemory();
                    long begin = System.currentTimeMillis();
                    Mapping m = SetOperations.getMapping(m1, m2, this.operator);
                    long end = System.currentTimeMillis();
                    long endMemory = Runtime.getRuntime().totalMemory();
                    System.out.println(sourceSize + "\t" + targetSize + "\t" + (end - begin) + "\t" + m.getNumberofMappings() + "\t" + (endMemory - memory));
                }
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        for (int i = 1000; i <= 10000; i += 1000) {
            sizes.add(i);
        }
        int iterations = 20;
        System.out.println("\nOR\n");
        OperatorHistogram oh = new OperatorHistogram(sizes, 3, 20, iterations, SetOperations.Operator.OR);
        oh.computeHistogram();
        System.out.println("\nAND\n");
        oh = new OperatorHistogram(sizes, 3, 20, iterations, SetOperations.Operator.AND);
        oh.computeHistogram();
        System.out.println("\nDIFF\n");
        oh = new OperatorHistogram(sizes, 3, 20, iterations, SetOperations.Operator.DIFF);
        oh.computeHistogram();
        System.out.println("\nXOR\n");
        oh = new OperatorHistogram(sizes, 3, 20, iterations, SetOperations.Operator.XOR);
        oh.computeHistogram();
    }
}

