/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.costs;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.costs.Histogram;
import de.uni_leipzig.simba.execution.costs.HistogramEntry;
import de.uni_leipzig.simba.execution.histogram.GeneratorType;
import de.uni_leipzig.simba.measures.Measure;
import de.uni_leipzig.simba.measures.MeasureFactory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricHistogram
extends Histogram {
    public MetricHistogram(List<Integer> corpusSizes, List<Double> thresholds, GeneratorType type, List<String> generatorAttributes, int iterations) {
        super(corpusSizes, thresholds, type, generatorAttributes, iterations);
    }

    public void computeMeasureHistogram(String measure, String folder) {
        this.histogramData = new HistogramEntry[this.corpusSizes.size()][this.corpusSizes.size()][this.thresholds.size()];
        for (int i = 0; i < this.corpusSizes.size(); ++i) {
            for (int j = 0; j < this.corpusSizes.size(); ++j) {
                for (int k = 0; k < this.thresholds.size(); ++k) {
                    this.histogramData[i][j][k] = new HistogramEntry();
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        Measure metric = MeasureFactory.getMeasure(measure);
        for (int iteration = 0; iteration < this.iterations; ++iteration) {
            logger.info((Object)("Running iteration " + iteration + " of " + this.iterations));
            int sourceCount = 0;
            Iterator i$ = this.corpusSizes.iterator();
            while (i$.hasNext()) {
                int sourceSize = (Integer)i$.next();
                int targetCount = 0;
                Iterator i$2 = this.corpusSizes.iterator();
                while (i$2.hasNext()) {
                    int targetSize = (Integer)i$2.next();
                    int thresholdCount = 0;
                    this.generateData(sourceSize, targetSize);
                    Iterator i$3 = this.thresholds.iterator();
                    while (i$3.hasNext()) {
                        double threshold = (Double)i$3.next();
                        long runtime = System.currentTimeMillis();
                        long memory = Runtime.getRuntime().totalMemory();
                        Mapping m = new Mapping();
                        for (Instance sourceInstance : this.source.getAllInstances()) {
                            for (Instance targetInstance : this.target.getAllInstances()) {
                                double sim = metric.getSimilarity(targetInstance, targetInstance, "label", "label");
                                if (!(sim >= threshold)) continue;
                                m.add(sourceInstance.getUri(), targetInstance.getUri(), sim);
                            }
                        }
                        runtime = System.currentTimeMillis() - runtime;
                        memory = Runtime.getRuntime().totalMemory() - memory;
                        buffer = buffer.append(sourceSize).append("\t").append(targetSize).append("\t").append(this.sourceGenerator.getMean()).append("\t").append(this.sourceGenerator.getStandardDeviation()).append("\t").append(this.targetGenerator.getMean()).append("\t").append(this.targetGenerator.getStandardDeviation()).append("\t").append(threshold).append("\t").append(runtime).append("\t").append(memory).append("\t").append(m.getNumberofMappings()).append("\n");
                        this.histogramData[sourceCount][targetCount][thresholdCount].addMemory(memory);
                        this.histogramData[sourceCount][targetCount][thresholdCount].addRuntime(runtime);
                        this.histogramData[sourceCount][targetCount][thresholdCount].addMappingSize(m.getNumberofMappings());
                        ++thresholdCount;
                    }
                    ++targetCount;
                }
                ++sourceCount;
            }
        }
        for (int i = 0; i < this.corpusSizes.size(); ++i) {
            for (int j = 0; j < this.corpusSizes.size(); ++j) {
                for (int k = 0; k < this.thresholds.size(); ++k) {
                    this.histogramData[i][j][k].memory /= (long)this.iterations;
                    this.histogramData[i][j][k].runtime /= (long)this.iterations;
                    this.histogramData[i][j][k].mappingSize /= (long)this.iterations;
                }
            }
        }
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/linearRegression_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer1 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/runtime_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer2 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/mappings_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer3 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/memory_" + measure + "_" + this.sourceGenerator.getName())));
            writer.println(buffer);
            for (int i = 0; i < this.corpusSizes.size(); ++i) {
                for (int j = 0; j < this.corpusSizes.size(); ++j) {
                    writer1.print(this.histogramData[i][j][0].runtime + "\t");
                    writer2.print(this.histogramData[i][j][0].mappingSize + "\t");
                    writer3.print(this.histogramData[i][j][0].memory + "\t");
                }
                writer1.println();
                writer2.println();
                writer3.println();
            }
            writer.close();
            writer.close();
            writer1.close();
            writer2.close();
            writer3.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("Error writing histogram data for " + metric.getName()));
        }
    }
}

