/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution.costs;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.costs.HistogramEntry;
import de.uni_leipzig.simba.execution.costs.MetricHistogram;
import de.uni_leipzig.simba.execution.histogram.DataGenerator;
import de.uni_leipzig.simba.execution.histogram.DumpBasedGenerator;
import de.uni_leipzig.simba.execution.histogram.GeneratorType;
import de.uni_leipzig.simba.execution.histogram.RandomNumberGenerator;
import de.uni_leipzig.simba.execution.histogram.RandomStringGenerator;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.measures.MeasureFactory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram {
    Cache source;
    Cache target;
    Map<Integer, Cache> sources = new HashMap<Integer, Cache>();
    Map<Integer, Cache> targets = new HashMap<Integer, Cache>();
    DataGenerator sourceGenerator;
    DataGenerator targetGenerator;
    List<Integer> corpusSizes;
    List<Double> thresholds;
    int iterations;
    HistogramEntry[][][] histogramData;
    double averageSourceStringLenght = 0.0;
    double averageTargetStringLenght = 0.0;
    static Logger logger = Logger.getLogger((String)"LIMES");

    public Histogram(List<Integer> corpusSizes, List<Double> thresholds, GeneratorType type, List<String> generatorAttributes, int iterations) {
        this.corpusSizes = corpusSizes;
        this.thresholds = thresholds;
        this.iterations = iterations;
        if (type.equals((Object)GeneratorType.DUMPBASED)) {
            this.sourceGenerator = new DumpBasedGenerator(generatorAttributes.get(0));
            this.targetGenerator = new DumpBasedGenerator(generatorAttributes.get(0));
        } else if (type.equals((Object)GeneratorType.RANDOMSTRING)) {
            this.sourceGenerator = new RandomStringGenerator(Integer.parseInt(generatorAttributes.get(0)), Integer.parseInt(generatorAttributes.get(1)));
            this.targetGenerator = new RandomStringGenerator(Integer.parseInt(generatorAttributes.get(0)), Integer.parseInt(generatorAttributes.get(1)));
        } else if (type.equals((Object)GeneratorType.RANDOMNUMBER)) {
            this.sourceGenerator = new RandomNumberGenerator(Integer.parseInt(generatorAttributes.get(0)), Integer.parseInt(generatorAttributes.get(1)));
            this.targetGenerator = new RandomNumberGenerator(Integer.parseInt(generatorAttributes.get(0)), Integer.parseInt(generatorAttributes.get(1)));
        }
    }

    public void generateData() {
        this.sources = new HashMap<Integer, Cache>();
        this.targets = new HashMap<Integer, Cache>();
        for (int size : this.corpusSizes) {
            this.sources.put(size, this.sourceGenerator.generateData(size));
            this.targets.put(size, this.targetGenerator.generateData(size));
        }
    }

    public void generateData(int sourceSize, int targetSize) {
        this.source = this.sourceGenerator.generateData(sourceSize);
        this.target = this.targetGenerator.generateData(targetSize);
    }

    public void computeHistogram(String measure, String folder) {
        this.histogramData = new HistogramEntry[this.corpusSizes.size()][this.corpusSizes.size()][this.thresholds.size()];
        for (int i = 0; i < this.corpusSizes.size(); ++i) {
            for (int j = 0; j < this.corpusSizes.size(); ++j) {
                for (int k = 0; k < this.thresholds.size(); ++k) {
                    this.histogramData[i][j][k] = new HistogramEntry();
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        AtomicMapper mapper = MeasureFactory.getMapper(measure);
        for (int iteration = 0; iteration < this.iterations; ++iteration) {
            logger.info((Object)("Running iteration " + iteration + " of " + this.iterations));
            int sourceCount = 0;
            for (int sourceSize : this.corpusSizes) {
                int targetCount = 0;
                for (int targetSize : this.corpusSizes) {
                    int thresholdCount = 0;
                    this.generateData(sourceSize, targetSize);
                    for (double threshold : this.thresholds) {
                        long runtime = System.currentTimeMillis();
                        long memory = Runtime.getRuntime().totalMemory();
                        Mapping m = mapper.getMapping(this.source, this.target, "?x", "?y", measure + "(x." + "label" + ", y." + "label" + ")", threshold);
                        runtime = System.currentTimeMillis() - runtime;
                        memory = Runtime.getRuntime().totalMemory() - memory;
                        buffer = buffer.append(sourceSize).append("\t").append(targetSize).append("\t").append(this.sourceGenerator.getMean()).append("\t").append(this.sourceGenerator.getStandardDeviation()).append("\t").append(this.targetGenerator.getMean()).append("\t").append(this.targetGenerator.getStandardDeviation()).append("\t").append(threshold).append("\t").append(runtime).append("\t").append(memory).append("\t").append(m.getNumberofMappings()).append("\n");
                        this.histogramData[sourceCount][targetCount][thresholdCount].addMemory(memory);
                        this.histogramData[sourceCount][targetCount][thresholdCount].addRuntime(runtime);
                        this.histogramData[sourceCount][targetCount][thresholdCount].addMappingSize(m.getNumberofMappings());
                        ++thresholdCount;
                    }
                    ++targetCount;
                }
                ++sourceCount;
            }
        }
        for (int i = 0; i < this.corpusSizes.size(); ++i) {
            for (int j = 0; j < this.corpusSizes.size(); ++j) {
                for (int k = 0; k < this.thresholds.size(); ++k) {
                    this.histogramData[i][j][k].memory /= (long)this.iterations;
                    this.histogramData[i][j][k].runtime /= (long)this.iterations;
                    this.histogramData[i][j][k].mappingSize /= (long)this.iterations;
                }
            }
        }
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/linearRegression_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer1 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/runtime_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer2 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/mappings_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer3 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/memory_" + measure + "_" + this.sourceGenerator.getName())));
            writer.println(buffer);
            for (int i = 0; i < this.corpusSizes.size(); ++i) {
                for (int j = 0; j < this.corpusSizes.size(); ++j) {
                    writer1.print(this.histogramData[i][j][0].runtime + "\t");
                    writer2.print(this.histogramData[i][j][0].mappingSize + "\t");
                    writer3.print(this.histogramData[i][j][0].memory + "\t");
                }
                writer1.println();
                writer2.println();
                writer3.println();
            }
            writer.close();
            writer.close();
            writer1.close();
            writer2.close();
            writer3.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("Error writing histogram data for " + mapper.getName()));
        }
    }

    public void computeFilterHistogram(String measure, String folder) {
        this.histogramData = new HistogramEntry[this.corpusSizes.size()][this.corpusSizes.size()][this.thresholds.size()];
        for (int i = 0; i < this.corpusSizes.size(); ++i) {
            for (int j = 0; j < this.corpusSizes.size(); ++j) {
                for (int k = 0; k < this.thresholds.size(); ++k) {
                    this.histogramData[i][j][k] = new HistogramEntry();
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        AtomicMapper mapper = MeasureFactory.getMapper(measure);
        for (int iteration = 0; iteration < this.iterations; ++iteration) {
            int sourceCount = 0;
            for (int sourceSize : this.corpusSizes) {
                int targetCount = 0;
                for (int targetSize : this.corpusSizes) {
                    int thresholdCount = 0;
                    this.generateData(sourceSize, targetSize);
                    for (double threshold : this.thresholds) {
                        Mapping m = mapper.getMapping(this.source, this.target, "?x", "?y", measure + "(x." + "label" + ", y." + "label" + ")", threshold);
                        long runtime = System.currentTimeMillis();
                        long memory = Runtime.getRuntime().totalMemory();
                        LinearFilter filter = new LinearFilter();
                        m = filter.filter(m, measure + "(x." + "label" + ", y." + "label" + ")", threshold, this.source, this.target, "?x", "?y");
                        runtime = System.currentTimeMillis() - runtime;
                        System.gc();
                        memory = Runtime.getRuntime().totalMemory() - memory;
                        buffer = buffer.append(sourceSize).append("\t").append(targetSize).append("\t").append("\t").append(this.sourceGenerator.getMean()).append("\t").append(this.sourceGenerator.getStandardDeviation()).append("\t").append(this.targetGenerator.getMean()).append("\t").append(this.targetGenerator.getStandardDeviation()).append(threshold).append("\t").append(runtime).append("\t").append(memory).append("\t").append(m.getNumberofMappings()).append("\n");
                        this.histogramData[sourceCount][targetCount][thresholdCount].addMemory(memory);
                        this.histogramData[sourceCount][targetCount][thresholdCount].addRuntime(runtime);
                        this.histogramData[sourceCount][targetCount][thresholdCount].addMappingSize(m.getNumberofMappings());
                        ++thresholdCount;
                    }
                    ++targetCount;
                }
                ++sourceCount;
            }
        }
        for (int i = 0; i < this.corpusSizes.size(); ++i) {
            for (int j = 0; j < this.corpusSizes.size(); ++j) {
                for (int k = 0; k < this.thresholds.size(); ++k) {
                    this.histogramData[i][j][k].memory /= (long)this.iterations;
                    this.histogramData[i][j][k].runtime /= (long)this.iterations;
                    this.histogramData[i][j][k].mappingSize /= (long)this.iterations;
                }
            }
        }
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/filter_linearRegression_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer1 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/filter_runtime_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer2 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/filter_mappings_" + measure + "_" + this.sourceGenerator.getName())));
            PrintWriter writer3 = new PrintWriter(new BufferedWriter(new FileWriter(folder + "/filter_memory_" + measure + "_" + this.sourceGenerator.getName())));
            writer.println(buffer);
            for (int i = 0; i < this.corpusSizes.size(); ++i) {
                for (int j = 0; j < this.corpusSizes.size(); ++j) {
                    writer1.print(this.histogramData[i][j][0].runtime + "\t");
                    writer2.print(this.histogramData[i][j][0].mappingSize + "\t");
                    writer3.print(this.histogramData[i][j][0].memory + "\t");
                }
                writer1.println();
                writer2.println();
                writer3.println();
            }
            writer.close();
            writer.close();
            writer1.close();
            writer2.close();
            writer3.close();
        }
        catch (Exception e) {
            logger.warn((Object)("Error writing histogram data for " + mapper.getName()));
        }
    }

    public static void main(String[] args) {
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, "histogram.log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        ArrayList<Integer> corpusSize = new ArrayList<Integer>();
        for (int i = 1000; i <= 10000; i += 1000) {
            corpusSize.add(i);
        }
        int iterations = 10;
        int lengthMax = 20;
        int lengthMin = 3;
        int min = 1;
        int max = 1000000;
        ArrayList<Double> thresholds = new ArrayList<Double>();
        thresholds.add(0.5);
        thresholds.add(0.6);
        thresholds.add(0.7);
        thresholds.add(0.8);
        thresholds.add(0.9);
        List<String> measures = Arrays.asList("trigrams", "levensthein", "qgrams", "jaccard");
        List<String> languages = Arrays.asList("de", "fr", "rand", "en");
        ArrayList<String> dump = new ArrayList<String>();
        String basePath = "/home/ngonga/devan/helios/metrics";
        logger.info((Object)"Processing German");
        logger.info((Object)"German data dumpbased processing");
        dump.add(basePath + "/labels_en_uris_de.nt");
        Histogram cc = new MetricHistogram(corpusSize, thresholds, GeneratorType.DUMPBASED, dump, iterations);
        logger.info((Object)"Running Trigrams ... ");
        String path = basePath + "/de";
        cc.computeHistogram("trigrams", path);
        cc.computeFilterHistogram("trigrams", path);
        logger.info((Object)"Running Jaccard ... ");
        cc.computeHistogram("jaccard", path);
        cc.computeFilterHistogram("jaccard", path);
        logger.info((Object)"Running EDJoin ... ");
        cc.computeHistogram("levenshtein", path);
        cc.computeFilterHistogram("levenshtein", path);
        logger.info((Object)"Running FastNGram ... ");
        cc.computeHistogram("qgrams", path);
        cc.computeFilterHistogram("qgrams", path);
        dump = new ArrayList();
        dump.add(basePath + "/labels_en_uris_fr.nt");
        logger.info((Object)"French data dumpbased processing");
        cc = new Histogram(corpusSize, thresholds, GeneratorType.DUMPBASED, dump, iterations);
        path = basePath + "/fr";
        logger.info((Object)"Running PPJoinPlus ... ");
        cc.computeHistogram("trigrams", path);
        cc.computeFilterHistogram("trigrams", path);
        cc.computeHistogram("jaccard", path);
        cc.computeFilterHistogram("jaccard", path);
        logger.info((Object)"Running EDJoin ... ");
        cc.computeHistogram("levenshtein", path);
        cc.computeFilterHistogram("levenshtein", path);
        logger.info((Object)"Running FastNGram ... ");
        cc.computeHistogram("qgrams", path);
        cc.computeFilterHistogram("qgrams", path);
        dump = new ArrayList();
        path = basePath + "/en";
        logger.info((Object)"Running PPJoinPlus ... ");
        dump.add(basePath + "/labels_en.nt");
        cc.computeHistogram("trigrams", path);
        cc.computeFilterHistogram("trigrams", path);
        cc.computeHistogram("jaccard", path);
        cc.computeFilterHistogram("jaccard", path);
        logger.info((Object)"Running EDJoin ... ");
        cc.computeHistogram("levenshtein", path);
        cc.computeFilterHistogram("levenshtein", path);
        logger.info((Object)"Running FastNGram ... ");
        cc.computeHistogram("qgrams", path);
        cc.computeFilterHistogram("qgrams", path);
        logger.info((Object)"Random string processing");
        dump = new ArrayList();
        dump.add(lengthMin + "");
        dump.add(lengthMax + "");
        path = basePath + "/rand";
        cc = new Histogram(corpusSize, thresholds, GeneratorType.RANDOMSTRING, dump, iterations);
        logger.info((Object)"Running PPJoinPlus ... ");
        cc.computeHistogram("trigrams", path);
        cc.computeFilterHistogram("trigrams", path);
        cc.computeHistogram("jaccard", path);
        cc.computeFilterHistogram("jaccard", path);
        logger.info((Object)"Running EDJoin ... ");
        cc.computeHistogram("levenshtein", path);
        cc.computeFilterHistogram("levenshtein", path);
        logger.info((Object)"Running FastNGram ... ");
        cc.computeHistogram("qgrams", path);
        cc.computeFilterHistogram("qgrams", path);
        logger.info((Object)"Processing numbers");
        dump = new ArrayList();
        dump.add(min + "");
        dump.add(max + "");
        path = basePath + "/numb";
        cc = new Histogram(corpusSize, thresholds, GeneratorType.RANDOMNUMBER, dump, iterations);
        String measure = "euclidean";
        logger.info((Object)("Running " + MeasureFactory.getMapper(measure).getName()));
        cc.computeHistogram(measure, path);
        cc.computeFilterHistogram(measure, path);
        logger.info((Object)"Done.");
    }
}

