/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution;

import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.execution.ExecutionPlan;
import de.uni_leipzig.simba.execution.Instruction;
import de.uni_leipzig.simba.execution.planner.CanonicalPlanner;
import de.uni_leipzig.simba.execution.planner.HeliosPlanner;
import de.uni_leipzig.simba.measures.MeasureProcessor;
import de.uni_leipzig.simba.selfconfig.Experiment;
import de.uni_leipzig.simba.specification.LinkSpec;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedPlan
extends ExecutionPlan {
    public List<NestedPlan> subPlans;
    public Instruction.Command operator;
    public Instruction filteringInstruction;

    public NestedPlan() {
        this.instructionList = null;
        this.subPlans = null;
    }

    public List<String> getAllMeasures() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isAtomic() && this.filteringInstruction != null) {
            result.addAll(MeasureProcessor.getMeasures(this.filteringInstruction.getMeasureExpression()));
        }
        if (this.subPlans != null && !this.subPlans.isEmpty()) {
            for (NestedPlan p : this.subPlans) {
                result.addAll(p.getAllMeasures());
            }
        }
        if (this.instructionList != null) {
            for (Instruction i : this.instructionList) {
                if (i.getMeasureExpression() == null) continue;
                result.addAll(MeasureProcessor.getMeasures(i.getMeasureExpression()));
            }
        }
        return result;
    }

    public boolean isAtomic() {
        if (this.subPlans == null) {
            return true;
        }
        return this.subPlans.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.instructionList == null && this.subPlans == null && this.filteringInstruction == null;
    }

    public String toString() {
        String pre = "Selectivity = " + this.selectivity;
        if (this.isEmpty()) {
            return "Empty plan";
        }
        if (this.isAtomic()) {
            if (this.instructionList != null) {
                return "\n\nBEGIN\n" + pre + "\n-----\nNULL\n" + this.instructionList + "\nEND\n-----";
            }
            return "\nBEGIN\n" + pre + "-----\nNULL\n" + this.filteringInstruction + "\nEND\n-----";
        }
        return "\nBEGIN\n" + pre + "-----\n" + this.filteringInstruction + "\nSubplans\n" + (Object)((Object)this.operator) + "\n" + this.subPlans + "\nEND\n-----";
    }

    public String getFilterString(String filter) {
        String[] parts = filter.split("\t");
        String result = parts[0];
        if (!parts[1].equals("null")) {
            result = result + "\n" + parts[1];
        }
        result = result + "\n" + parts[2];
        return result;
    }

    public String getEquivalentMeasure() {
        String result;
        if (this.isAtomic()) {
            result = ((Instruction)this.instructionList.get(0)).getMeasureExpression();
        } else {
            if (this.subPlans.size() == 1 && this.filteringInstruction != null) {
                if (this.filteringInstruction.getMeasureExpression() == null) {
                    return this.subPlans.get(0).getEquivalentMeasure();
                }
                return "AND(" + this.filteringInstruction.getMeasureExpression() + "|" + this.filteringInstruction.getThreshold() + "," + this.subPlans.get(0).getEquivalentMeasure() + "|" + ((Instruction)this.subPlans.get((int)0).instructionList.get(0)).getThreshold() + ")";
            }
            result = this.operator == Instruction.Command.INTERSECTION ? "AND(" : (this.operator == Instruction.Command.UNION ? "OR(" : (this.operator == Instruction.Command.XOR ? "XOR(" : (this.operator == Instruction.Command.DIFF ? "MINUS(" : "")));
            for (NestedPlan p : this.subPlans) {
                result = result + p.getEquivalentMeasure() + "|";
                if (p.isAtomic()) {
                    result = result + ((Instruction)p.instructionList.get(0)).getThreshold() + ",";
                    continue;
                }
                if (p.filteringInstruction == null) continue;
                result = result + p.filteringInstruction.getThreshold() + ",";
            }
            result = result.substring(0, result.length() - 1);
            result = result + ")";
            if (this.instructionList != null && !this.instructionList.isEmpty()) {
                for (Instruction i : this.instructionList) {
                    result = "AND(" + i.getMeasureExpression() + "|" + i.getThreshold() + "," + result + ")";
                }
            }
        }
        if (this.filteringInstruction != null && this.filteringInstruction.getMeasureExpression() != null) {
            result = "AND(" + this.filteringInstruction.getMeasureExpression() + "|" + this.filteringInstruction.getThreshold() + "," + result + "|" + this.filteringInstruction.getThreshold() + ")";
        }
        return result;
    }

    public String getThreshold() {
        if (this.filteringInstruction != null) {
            return this.filteringInstruction.getThreshold();
        }
        return "0";
    }

    public int getSize(String s) {
        int size = 0;
        if (s.contains("\n")) {
            String[] parts = s.split("\n");
            for (int i = 0; i < parts.length; ++i) {
                size = Math.max(size, parts[i].length());
            }
            return size;
        }
        return s.length();
    }

    public String getInstructionString(List<Instruction> list) {
        Instruction i = list.get(0);
        String result = (Object)((Object)i.getCommand()) + "\n";
        result = result + i.getMeasureExpression() + "\n";
        result = result + i.getThreshold();
        return result;
    }

    public void draw(mxGraph graph, Object root) {
        int charsize = 8;
        Object parent = graph.getDefaultParent();
        if (this.isAtomic()) {
            Object v;
            if (this.instructionList != null && !this.instructionList.isEmpty()) {
                String inst = this.getInstructionString(this.instructionList);
                v = graph.insertVertex(parent, null, (Object)inst, 20.0, 40.0, (double)(this.getSize(inst) * charsize), 45.0, "ROUNDED");
            } else {
                String filter = this.getFilterString(this.filteringInstruction.toString());
                v = graph.insertVertex(parent, null, (Object)filter, 20.0, 40.0, (double)(this.getSize(filter) * charsize), 45.0, "ROUNDED");
            }
            if (root != null) {
                graph.insertEdge(parent, null, (Object)"", root, v);
            }
        } else {
            String filter = this.filteringInstruction != null ? this.getFilterString(this.filteringInstruction.toString()) : "NULL";
            Object v1 = graph.insertVertex(parent, null, (Object)filter, 20.0, 40.0, (double)(this.getSize(filter) * charsize), 45.0, "ROUNDED");
            Object v2 = graph.insertVertex(parent, null, (Object)this.operator, 20.0, 40.0, (double)(((Object)((Object)this.operator) + "").length() * charsize), 45.0, "RECTANGLE");
            graph.insertEdge(parent, null, (Object)"", root, v1);
            graph.insertEdge(parent, null, (Object)"", v1, v2);
            for (NestedPlan p : this.subPlans) {
                p.draw(graph, v2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public mxGraph getGraph() {
        mxGraph graph = new mxGraph();
        mxStylesheet stylesheet = graph.getStylesheet();
        Hashtable<String, Object> rounded = new Hashtable<String, Object>();
        rounded.put(mxConstants.STYLE_SHAPE, "ellipse");
        rounded.put(mxConstants.STYLE_OPACITY, 50);
        rounded.put(mxConstants.STYLE_FILLCOLOR, "#FF5240");
        rounded.put(mxConstants.STYLE_FONTCOLOR, "#000000");
        stylesheet.putCellStyle("ROUNDED", rounded);
        Hashtable<String, Object> rectangle = new Hashtable<String, Object>();
        rectangle.put(mxConstants.STYLE_SHAPE, "rectangle");
        rectangle.put(mxConstants.STYLE_OPACITY, 50);
        rectangle.put(mxConstants.STYLE_FILLCOLOR, "#5FEB3B");
        rectangle.put(mxConstants.STYLE_FONTCOLOR, "#000000");
        stylesheet.putCellStyle("RECTANGLE", rectangle);
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        try {
            this.draw(graph, null);
        }
        finally {
            graph.getModel().endUpdate();
        }
        mxCompactTreeLayout layout = new mxCompactTreeLayout(graph);
        layout.setHorizontal(false);
        layout.execute(graph.getDefaultParent());
        return graph;
    }

    public void draw() {
        mxGraph graph = this.getGraph();
        mxGraphComponent graphComponent = new mxGraphComponent(graph);
        graphComponent.getViewport().setOpaque(false);
        graphComponent.setBackground(Color.WHITE);
        JFrame frame = new JFrame();
        frame.setSize(500, 500);
        frame.setLocation(300, 200);
        frame.setBackground(Color.white);
        frame.add((Component)graphComponent);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        CanonicalPlanner cp = new CanonicalPlanner();
        Cache source = Experiment.readFile("E:/Work/Data/Datenbanken/DBLP-ACM/DBLP.csv");
        HeliosPlanner hp = new HeliosPlanner(source, source);
        LinkSpec spec = new LinkSpec();
        spec.readSpec("AND(euclidean(x.year,y.year)|0.8019,OR(cosine(x.title,y.title)|0.5263,AND(cosine(x.authors,y.authors)|0.5263,overlap(x.title,y.title)|0.5263)|0.2012)|0.2012)", 0.3627);
        NestedPlan np = hp.plan(spec);
        np.draw();
        np = cp.plan(spec);
        np.draw();
        System.out.println(np.getEquivalentMeasure());
    }
}

