/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.ExecutionPlan;
import de.uni_leipzig.simba.execution.Instruction;
import de.uni_leipzig.simba.execution.NestedPlan;
import de.uni_leipzig.simba.execution.planner.CanonicalPlanner;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.SetOperations;
import de.uni_leipzig.simba.mapper.atomic.EDJoin;
import de.uni_leipzig.simba.mapper.atomic.PPJoinPlusPlus;
import de.uni_leipzig.simba.mapper.atomic.TotalOrderBlockingMapper;
import de.uni_leipzig.simba.specification.LinkSpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ExecutionEngine {
    static Logger logger = Logger.getLogger((String)"LIMES");
    private List<Mapping> buffer = new ArrayList<Mapping>();
    private String sourceVariable;
    private String targetVariable;
    private Cache source;
    private Cache target;

    public ExecutionEngine(Cache source, Cache target, String sourceVar, String targetVar) {
        this.source = source;
        this.target = target;
        this.sourceVariable = sourceVar;
        this.targetVariable = targetVar;
    }

    public Mapping run(ExecutionPlan plan) {
        logger.info((Object)"Beginning with execution of linear plan");
        this.buffer = new ArrayList<Mapping>();
        if (plan.isEmpty()) {
            logger.info((Object)"Plan is empty. Done.");
            return new Mapping();
        }
        List<Instruction> instructions = plan.getInstructionList();
        Mapping m = new Mapping();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction inst = instructions.get(i);
            logger.info((Object)("Running instruction " + inst + " ..."));
            int index = inst.getResultIndex();
            if (inst.getCommand().equals((Object)Instruction.Command.RUN)) {
                m = this.executeRun(inst);
            } else if (inst.getCommand().equals((Object)Instruction.Command.FILTER)) {
                m = this.executeFilter(inst, this.buffer.get(inst.getSourceMapping()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.INTERSECTION)) {
                m = SetOperations.intersection(this.buffer.get(inst.getSourceMapping()), this.buffer.get(inst.getTargetMapping()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.UNION)) {
                m = SetOperations.union(this.buffer.get(inst.getSourceMapping()), this.buffer.get(inst.getTargetMapping()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.DIFF)) {
                m = SetOperations.difference(this.buffer.get(inst.getSourceMapping()), this.buffer.get(inst.getTargetMapping()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.RETURN)) {
                logger.info((Object)"Reached return command. Returning results.");
                if (this.buffer.isEmpty()) {
                    return m;
                }
                if (index < 0) {
                    return this.buffer.get(this.buffer.size() - 1);
                }
                return this.buffer.get(index);
            }
            if (index < 0) {
                this.buffer.add(m);
                continue;
            }
            while (index + 1 > this.buffer.size()) {
                this.buffer.add(new Mapping());
            }
            this.buffer.set(index, m);
        }
        if (this.buffer.isEmpty()) {
            return new Mapping();
        }
        logger.info((Object)("Done. Returning " + this.buffer.get(this.buffer.size() - 1).getNumberofMappings() + " results."));
        return this.buffer.get(this.buffer.size() - 1);
    }

    public Mapping executeRun(Instruction inst) {
        double threshold = Double.parseDouble(inst.getThreshold());
        AtomicMapper mapper = inst.getMeasureExpression().startsWith("leven") ? new EDJoin() : (inst.getMeasureExpression().startsWith("euclid") ? new TotalOrderBlockingMapper() : new PPJoinPlusPlus());
        return mapper.getMapping(this.source, this.target, this.sourceVariable, this.targetVariable, inst.getMeasureExpression(), threshold);
    }

    private Mapping executeFilter(Instruction inst, Mapping input) {
        LinearFilter filter = new LinearFilter();
        return filter.filter(input, inst.getMeasureExpression(), Double.parseDouble(inst.getThreshold()), this.source, this.target, this.sourceVariable, this.targetVariable);
    }

    private Mapping executeIntersection(Instruction inst, Mapping m1, Mapping m2) {
        return SetOperations.intersection(m1, m2);
    }

    private Mapping executeUnion(Instruction inst, Mapping m1, Mapping m2) {
        return SetOperations.union(m1, m2);
    }

    public static void testNestedPlanExecution() {
        MemoryCache source = new MemoryCache();
        source.addTriple("S1", "surname", "sandra");
        source.addTriple("S1", "name", "bullock");
        source.addTriple("S2", "surname", "lukas");
        source.addTriple("S2", "name", "duke");
        source.addTriple("S1", "age", "31");
        source.addTriple("S2", "age", "31");
        MemoryCache target = new MemoryCache();
        target.addTriple("T1", "surname", "sandy");
        target.addTriple("T1", "name", "bullock");
        target.addTriple("T1", "alter", "31");
        target.addTriple("T2", "surname", "luke");
        target.addTriple("T2", "name", "duke");
        target.addTriple("T2", "alter", "30");
        String metric = "OR(AND(trigrams(x.name, y.name)|1, euclidean(x.age, y.alter)|1)|0, AND(trigrams(x.name, y.name)|0.8, levenshtein(x.surname, y.surname)|0.25)|0.1)";
        LinkSpec spec = new LinkSpec(metric, 0.3);
        CanonicalPlanner cp = new CanonicalPlanner();
        NestedPlan plan = cp.plan(spec);
        logger.info((Object)plan);
        ExecutionEngine ee = new ExecutionEngine(source, target, "?x", "?y");
        System.out.println("Nested Plan Result = " + ee.runNestedPlan(plan));
    }

    public static void test() {
        MemoryCache source = new MemoryCache();
        source.addTriple("S1", "surname", "sandra");
        source.addTriple("S1", "name", "bullock");
        source.addTriple("S2", "surname", "lukas");
        source.addTriple("S2", "name", "duke");
        source.addTriple("S1", "age", "31");
        source.addTriple("S1", "age", "31");
        MemoryCache target = new MemoryCache();
        target.addTriple("T1", "surname", "sandy");
        target.addTriple("T1", "name", "bullock");
        target.addTriple("T1", "alter", "31");
        target.addTriple("T2", "surname", "lukas");
        target.addTriple("T2", "name", "dorkas");
        target.addTriple("T2", "name", "12");
        Instruction i1 = new Instruction(Instruction.Command.RUN, "levenshtein(x.surname, y.surname)", "0.5", -1, -1, 0);
        Instruction i2 = new Instruction(Instruction.Command.RUN, "levenshtein(x.name, y.name)", "0.5", -1, -1, 1);
        Instruction i3 = new Instruction(Instruction.Command.UNION, "", "0.5", 0, 1, 2);
        ExecutionPlan plan = new ExecutionPlan();
        plan.addInstruction(i1);
        plan.addInstruction(i2);
        plan.addInstruction(i3);
        ExecutionEngine ee = new ExecutionEngine(source, target, "?x", "?y");
        System.out.println(source);
        System.out.println(target);
        Mapping m1 = ee.executeRun(i1);
        System.out.println(m1);
        Mapping m2 = ee.executeRun(i2);
        System.out.println(m2);
        Mapping m3 = ee.executeUnion(i3, m1, m2);
        System.out.println(m3);
        System.out.println(ee.run(plan));
    }

    public Mapping runNestedPlan(NestedPlan nestedPlan) {
        long begin = System.currentTimeMillis();
        Mapping m = new Mapping();
        if (!nestedPlan.isEmpty()) {
            if (nestedPlan.isAtomic()) {
                m = this.run(nestedPlan);
            } else {
                Mapping result = m = this.runNestedPlan(nestedPlan.subPlans.get(0));
                for (int i = 1; i < nestedPlan.subPlans.size(); ++i) {
                    Mapping m2 = this.runNestedPlan(nestedPlan.subPlans.get(i));
                    if (nestedPlan.operator.equals((Object)Instruction.Command.INTERSECTION)) {
                        result = SetOperations.intersection(m, m2);
                    } else if (nestedPlan.operator.equals((Object)Instruction.Command.UNION)) {
                        result = SetOperations.union(m, m2);
                    } else if (nestedPlan.operator.equals((Object)Instruction.Command.DIFF)) {
                        result = SetOperations.difference(m, m2);
                    } else if (nestedPlan.operator.equals((Object)Instruction.Command.XOR)) {
                        result = SetOperations.xor(m, m2);
                    }
                    logger.info((Object)("Running " + (Object)((Object)nestedPlan.operator) + " on " + m.getNumberofMappings() + "results and " + m2.getNumberofMappings() + " " + "mappings and got " + result.getNumberofMappings() + " mappings."));
                    m = result;
                }
                if (nestedPlan.filteringInstruction != null && Double.parseDouble(nestedPlan.filteringInstruction.getThreshold()) > 0.0) {
                    logger.info((Object)("Filtering with " + nestedPlan.filteringInstruction));
                    m = this.executeFilter(nestedPlan.filteringInstruction, m);
                }
            }
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("Running took " + (end - begin) + " ms."));
        return m;
    }

    public static void main(String[] args) {
        ExecutionEngine.testNestedPlanExecution();
    }
}

