/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.execution;

import de.uni_leipzig.gk.cluster.BorderFlowHard;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.ExecutionEngine;
import de.uni_leipzig.simba.execution.Instruction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReducer {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static Set<String> getPrototypical(Cache cache, String property, String measure, double threshold) {
        String measureExpression = measure + "(x." + property + ", y." + property + ")";
        Instruction inst = new Instruction(Instruction.Command.RUN, measureExpression, threshold + "", -1, -1, -1);
        ExecutionEngine ee = new ExecutionEngine(cache, cache, "?x", "?y");
        Mapping data = ee.executeRun(inst);
        logger.info((Object)("Mapping = " + data));
        Map<Set<String>, Set<String>> clusters = DataReducer.getClusters(data);
        Collection<Set<String>> values = clusters.values();
        HashSet<String> result = new HashSet<String>();
        for (Set<String> v : values) {
            result.add(DataReducer.getPrototypical(data, v));
        }
        logger.info((Object)("Got " + result.size() + " prototypical values for property <" + property + "> with measure <" + measure + ">" + "and threshold " + threshold));
        return result;
    }

    private static Map<Set<String>, Set<String>> getClusters(Mapping graph) {
        HashMap<Set<String>, Set<String>> results = new HashMap<Set<String>, Set<String>>();
        try {
            File f = File.createTempFile("www", "ww");
            String name = f.getAbsolutePath();
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(name)));
            for (String s : graph.map.keySet()) {
                for (String t : graph.map.get(s).keySet()) {
                    writer.println(s + "\t" + t + "\t" + graph.getSimilarity(s, t));
                }
            }
            writer.close();
            BorderFlowHard bf = new BorderFlowHard(name);
            bf.hardPartitioning = false;
            Map clusters = bf.cluster(-1.0, true, true, true);
            return clusters;
        }
        catch (Exception e) {
            e.printStackTrace();
            return results;
        }
    }

    public static String getPrototypical(Mapping m, Set<String> clusters) {
        if (clusters.isEmpty()) {
            return null;
        }
        if (clusters.size() == 1 || clusters.size() == 2) {
            return clusters.iterator().next();
        }
        double maxSim = 0.0;
        String best = clusters.iterator().next();
        for (String s : clusters) {
            double sim = 0.0;
            for (String t : clusters) {
                sim += m.getSimilarity(s, t);
            }
            if (!(sim > maxSim)) continue;
            maxSim = sim;
            best = s;
        }
        return best;
    }

    public static void main(String[] args) {
        MemoryCache c = new MemoryCache();
        for (int i = 0; i < 100; ++i) {
            c.addTriple(i + "", "label", Math.floor(1000.0 * Math.random()) + "");
        }
        System.out.println(c);
        Set<String> results = DataReducer.getPrototypical(c, "label", "levenshtein", 0.33);
        System.out.println(results);
    }
}

