/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.evaluation;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import de.uni_leipzig.simba.query.QueryModule;
import de.uni_leipzig.simba.query.QueryModuleFactory;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class TotalOrderMapperEval {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static void usage() {
        System.out.println("====================");
        System.out.println("===     Usage    ===");
        System.out.println("====================");
        System.out.println("1. Config file");
        System.out.println("2. Min threshold");
        System.out.println("3. Max threshold");
        System.out.println("4. Min granularity");
        System.out.println("5. Max granularity");
        System.out.println("6. Number of repetitions");
    }

    public static void main(String[] args) {
        int maxThreshold = 1000;
        int minThreshold = 1;
        int fromGranularity = 1;
        int toGranularity = 1025;
        int repetitions = 5;
        if (args.length == 0) {
            TotalOrderMapperEval.usage();
            return;
        }
        if (args.length >= 2) {
            minThreshold = Integer.parseInt(args[1]);
        }
        if (args.length >= 3) {
            maxThreshold = Integer.parseInt(args[2]);
        }
        if (args.length >= 4) {
            fromGranularity = Integer.parseInt(args[3]);
        }
        if (args.length >= 5) {
            toGranularity = Integer.parseInt(args[4]);
        }
        if (args.length >= 6) {
            repetitions = Integer.parseInt(args[5]);
        }
        if (new File(args[0]).exists()) {
            if (new File(args[0]).isDirectory()) {
                String[] fileNames = new File(args[0]).list();
                for (int i = 0; i < fileNames.length; ++i) {
                    TotalOrderMapperEval.run(args[0] + "/" + fileNames[i], minThreshold, maxThreshold, fromGranularity, toGranularity, repetitions);
                }
            } else {
                TotalOrderMapperEval.run(args[0], minThreshold, maxThreshold, fromGranularity, toGranularity, repetitions);
            }
        } else {
            logger.fatal((Object)("Input file " + args[0] + " does not exist."));
            System.exit(1);
        }
    }

    public static void run(String configFile, int minThreshold, int maxThreshold, int minGranularity, int maxGranularity, int repetitions) {
        System.out.println("Experiment " + configFile);
        System.out.println("Max threshold =  " + maxThreshold);
        System.out.println("Max granularity =  " + maxGranularity);
        System.out.println("Max repetitions =  " + repetitions);
        long startTime = System.currentTimeMillis();
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        logger.setLevel(Level.DEBUG);
        ConfigReader cr = new ConfigReader();
        cr.validateAndRead(configFile);
        logger.info((Object)cr.getSourceInfo());
        logger.info((Object)cr.getTargetInfo());
        logger.info((Object)"Loading source data ...");
        HybridCache source = new HybridCache();
        source = TotalOrderMapperEval.getData(cr.getSourceInfo());
        logger.info((Object)"Loading target data ...");
        HybridCache target = new HybridCache();
        target = TotalOrderMapperEval.getData(cr.getTargetInfo());
        if (target.size() > source.size()) {
            logger.info((Object)"Swapping data sources as |T| > |S|");
            HybridCache help = target;
            target = source;
            source = help;
            KBInfo swap = cr.sourceInfo;
            cr.sourceInfo = cr.targetInfo;
            cr.targetInfo = swap;
        }
        HashMap times = new HashMap();
        String result = "\n\n";
        for (double threshold = (double)minThreshold; threshold < (double)maxThreshold; threshold *= 2.0) {
            result = result + "\nDistance Threshold = " + threshold + "\n=========\n";
            for (int granularity = minGranularity; granularity <= maxGranularity; granularity *= 2) {
                result = result + "Granularity = " + granularity + "\n";
                for (int j = 0; j < repetitions; ++j) {
                    logger.info((Object)("Processing granularity = " + granularity));
                    long begin = System.currentTimeMillis();
                    SetConstraintsMapper mapper = SetConstraintsMapperFactory.getMapper(cr.executionPlan, cr.sourceInfo, cr.targetInfo, source, target, new LinearFilter(), cr.granularity);
                    Mapping mapping = mapper.getLinks(cr.metricExpression, threshold);
                    long end = System.currentTimeMillis();
                    logger.info((Object)("Required " + (end - begin) + " ms."));
                    result = result + (end - begin) + "\t";
                }
                result = result + "\n";
            }
        }
        logger.info((Object)("Runtimes" + result));
        System.out.println("Runtimes" + result);
    }

    public static HybridCache getData(KBInfo kb) {
        HybridCache cache = new HybridCache();
        File cacheFile = new File("cache/" + kb.hashCode() + ".ser");
        try {
            if (cacheFile.exists()) {
                logger.info((Object)("Found cached data. Loading data from file " + cacheFile.getAbsolutePath()));
                cache = HybridCache.loadFromFile(cacheFile);
            }
            if (cache.size() == 0) {
                throw new Exception();
            }
            logger.info((Object)("Cached data loaded successfully from file " + cacheFile.getAbsolutePath()));
            logger.info((Object)("Size = " + cache.size()));
        }
        catch (Exception e) {
            logger.info((Object)("No cached data found for " + kb.id));
            QueryModule module = QueryModuleFactory.getQueryModule(kb.type, kb);
            module.fillCache(cache);
            if (!new File("cache").exists() || !new File("cache").isDirectory()) {
                new File("cache").mkdir();
            }
            cache.saveToFile(new File("cache/" + kb.hashCode() + ".ser"));
        }
        return cache;
    }
}

