/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.evaluation;

import de.uni_leipzig.simba.data.Mapping;
import org.junit.Assert;
import org.junit.Test;

public class PRFComputer {
    public double getOverlap(Mapping m, Mapping reference) {
        double counter = 0.0;
        for (String key : m.map.keySet()) {
            for (String value : m.map.get(key).keySet()) {
                if (!reference.map.containsKey(key) || !reference.map.get(key).containsKey(value)) continue;
                counter += 1.0;
            }
        }
        return counter;
    }

    public double computePrecision(Mapping m, Mapping reference) {
        return this.getOverlap(m, reference) / (double)m.size();
    }

    public double computeRecall(Mapping m, Mapping reference) {
        return this.getOverlap(m, reference) / (double)reference.size();
    }

    public double computeFScore(Mapping m, Mapping reference) {
        double overlap = this.getOverlap(m, reference);
        return 2.0 * (overlap / (double)m.size()) * (overlap / (double)reference.size()) / (overlap / (double)m.size() + overlap / (double)reference.size());
    }

    @Test
    public void testComputeFScore() {
        Mapping m1 = new Mapping();
        Mapping ref = new Mapping();
        m1.add("a", "b", 1.0);
        ref.add("a", "b", 1.0);
        m1.add("a", "c", 2.0);
        PRFComputer prf = new PRFComputer();
        double val = prf.computeFScore(m1, ref);
        Assert.assertTrue((val <= 1.0 ? 1 : 0) != 0);
    }

    public double computeDifference(Mapping m1, Mapping m2) {
        double counter = 0.0;
        for (String key : m1.map.keySet()) {
            for (String value : m1.map.get(key).keySet()) {
                if (m2.contains(key, value) || m2.contains(value, key)) continue;
                counter += 1.0;
            }
        }
        return counter;
    }

    public double computeMatthewsCorrelation(Mapping m, Mapping reference, double crossProduct) {
        double tp = this.getOverlap(m, reference);
        double fn = this.computeDifference(reference, m);
        double fp = this.computeDifference(m, reference);
        double tn = crossProduct - tp - fn - fp;
        double help = (tp + fp) * (tp + fn) * (tn + fp) * (tn + fn);
        double denom = 1.0;
        if (help > 0.0) {
            denom = Math.sqrt(help);
        }
        return (tp * tn - fp * fn) / denom;
    }

    @Test
    public void testcomputeMatthewsCorrelation() {
        Mapping m = new Mapping();
        Mapping reference = new Mapping();
        m.add("a", "c", 1.0);
        reference.add("a", "c", 1.0);
        double eps = 0.01;
        double val = this.computeMatthewsCorrelation(m, reference, 4.0);
        double ref = 1.0;
        Assert.assertTrue((Math.abs(val - ref) < eps ? 1 : 0) != 0);
        reference.add("b", "d", 1.0);
        val = this.computeMatthewsCorrelation(m, reference, 4.0);
        ref = 2.0 / Math.sqrt(12.0);
        Assert.assertTrue((Math.abs(val - ref) < eps ? 1 : 0) != 0);
        m = new Mapping();
        reference = new Mapping();
        m.add("a", "c", 1.0);
        reference.add("b", "d", 1.0);
        val = this.computeMatthewsCorrelation(m, reference, 4.0);
        ref = -0.3333333333333333;
        Assert.assertTrue((Math.abs(val - ref) < eps ? 1 : 0) != 0);
    }
}

