/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.evaluation;

import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.serializer.TtlSerializer;
import de.uni_leipzig.simba.metricfactory.SimpleMetricFactory;
import de.uni_leipzig.simba.organizer.BruteForceOrganizer;
import de.uni_leipzig.simba.organizer.DensityBasedOrganizer;
import de.uni_leipzig.simba.organizer.LimesOrganizer;
import de.uni_leipzig.simba.organizer.Organizer;
import de.uni_leipzig.simba.query.SparqlQueryModule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Eval {
    public static void runTest(String configFile, String[] organizerList, double[] thresholdList, String output) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(output)));
            writer.println("Organizer\tComparisons\tRuntime\tThreshold");
            long startTime = System.currentTimeMillis();
            Logger logger = Logger.getLogger((String)"LIMES");
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %c: %m%n");
            try {
                FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + "." + System.currentTimeMillis() + ".log", false);
                logger.addAppender((Appender)fileAppender);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception creating file appender.");
            }
            logger.setLevel(Level.DEBUG);
            ConfigReader cr = new ConfigReader();
            cr.validateAndRead(configFile);
            SparqlQueryModule sourceQm = new SparqlQueryModule(cr.getSourceInfo());
            MemoryCache source = new MemoryCache();
            sourceQm.fillCache(source);
            SparqlQueryModule targetQm = new SparqlQueryModule(cr.getTargetInfo());
            MemoryCache target = new MemoryCache();
            targetQm.fillCache(target);
            SimpleMetricFactory mf = new SimpleMetricFactory(cr.sourceInfo.var, cr.targetInfo.var);
            mf.setExpression(cr.metricExpression);
            logger.info((Object)("Comparisons will be carried out by using " + cr.metricExpression));
            SimpleMetricFactory organizerMf = new SimpleMetricFactory(cr.sourceInfo.var, cr.targetInfo.var);
            String var1 = cr.sourceInfo.var.replaceAll("\\?", "");
            String var2 = cr.targetInfo.var.replaceAll("\\?", "");
            organizerMf.setExpression(mf.foldExpression(cr.metricExpression, var2, var1));
            logger.info((Object)("Organizing will be carried out by using " + mf.foldExpression(cr.metricExpression, var2, var1)));
            for (int ol = 0; ol < organizerList.length; ++ol) {
                for (int tl = 0; tl < thresholdList.length; ++tl) {
                    Organizer organizer = organizerList[ol].toLowerCase().startsWith("density") ? new DensityBasedOrganizer() : (organizerList[ol].toLowerCase().startsWith("brute") ? new BruteForceOrganizer() : new LimesOrganizer());
                    cr.verificationThreshold = thresholdList[tl];
                    cr.acceptanceThreshold = 1.0;
                    if (cr.exemplars < 2) {
                        organizer.computeExemplars(target, organizerMf);
                    } else {
                        organizer.computeExemplars(target, organizerMf, cr.exemplars);
                    }
                    ArrayList<String> uris = source.getAllUris();
                    TtlSerializer accepted = new TtlSerializer();
                    TtlSerializer toReview = new TtlSerializer();
                    accepted.open(organizer.getName() + "_" + thresholdList[tl] + "_" + cr.acceptanceFile);
                    accepted.setPrefixes(cr.prefixes);
                    accepted.printPrefixes();
                    toReview.open(organizer.getName() + "_" + thresholdList[tl] + "_" + cr.verificationFile);
                    toReview.setPrefixes(cr.prefixes);
                    toReview.printPrefixes();
                    for (int i = 0; i < uris.size(); ++i) {
                        HashMap<String, Double> results = organizer.getSimilarInstances(source.getInstance(uris.get(i)), cr.verificationThreshold, mf);
                        for (String s : results.keySet()) {
                            if (results.get(s) >= cr.acceptanceThreshold) {
                                accepted.printStatement(uris.get(i), cr.acceptanceRelation, s, results.get(s));
                                continue;
                            }
                            if (!(results.get(s) >= cr.verificationThreshold)) continue;
                            toReview.printStatement(uris.get(i), cr.acceptanceRelation, s, results.get(s));
                        }
                    }
                    accepted.close();
                    toReview.close();
                    logger.info((Object)("Required " + organizer.getComparisons() + " comparisons overall.\n"));
                    logger.info((Object)("Comparisons were carried out in " + organizer.getComparisonTime() + " seconds overall.\n"));
                    logger.info((Object)("Required " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds overall."));
                    writer.println(organizer.getName() + "\t" + organizer.getComparisons() + "\t" + organizer.getComparisonTime() + "\t" + thresholdList[tl]);
                    logger.info((Object)"Done.");
                }
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        double[] thresholdList = new double[]{0.75, 0.8, 0.85, 0.9, 0.95};
        String[] organizerList = new String[]{"limes", "densitybased"};
        if (new File(args[0]).exists()) {
            Eval.runTest(args[0], organizerList, thresholdList, args[1]);
        } else {
            System.exit(1);
        }
    }
}

