/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.dofin.algorithm;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.dofin.svm.SvmChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dofin {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static Set<Set<String>> run(HashMap<String, Mapping> mappings) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        Set<String> properties = mappings.keySet();
        Set<Set<String>> powerSet = Dofin.powerSet(properties);
        for (int i = 1; i <= properties.size(); ++i) {
            Set pI = Dofin.getSubsets(powerSet, i);
            for (Set<String> set : pI) {
                HashSet<Mapping> data = new HashSet<Mapping>();
                for (String name : set) {
                    data.add(mappings.get(name));
                }
                if (Dofin.discriminative(data)) {
                    result.add(set);
                    powerSet = Dofin.reduce(powerSet, set);
                }
                if (!powerSet.isEmpty()) continue;
                return result;
            }
        }
        return result;
    }

    public static Set<Set<String>> runScalable(HashMap<String, Mapping> mappings, ArrayList<String> uris) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        Set<String> properties = mappings.keySet();
        Set<Set<String>> powerSet = Dofin.generateInitialSetofSets(properties);
        for (int i = 1; i <= properties.size(); ++i) {
            logger.info((Object)("Processing level " + i));
            logger.info((Object)("Powerset is currently " + powerSet));
            Set pI = Dofin.getSubsets(powerSet, i);
            for (Set<String> set : pI) {
                HashSet<Mapping> data = new HashSet<Mapping>();
                for (String property : set) {
                    data.add(mappings.get(property));
                }
                logger.info((Object)("Running the SVM for " + set));
                if (Dofin.discriminative(data, uris)) {
                    logger.info((Object)(set + " is discriminative ..."));
                    result.add(set);
                    powerSet = Dofin.reduce(powerSet, set);
                }
                if (powerSet.isEmpty()) {
                    return result;
                }
                powerSet = Dofin.generateNextLevel(powerSet, i + 1);
            }
        }
        return result;
    }

    public static boolean contains(Set<String> s1, Set<String> s2) {
        for (String s : s2) {
            if (s1.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static Set<Set<String>> reduce(Set<Set<String>> set, Set<String> properties) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        for (Set<String> r : set) {
            if (Dofin.contains(r, properties)) continue;
            result.add(r);
        }
        return result;
    }

    public static boolean discriminative(Set<Mapping> data, ArrayList<String> uris) {
        return SvmChecker.getDiscriminativeness(data, uris) >= 1.0;
    }

    public static boolean discriminative(Set<Mapping> data) {
        return SvmChecker.getDiscriminativeness(data) >= 1.0;
    }

    public static <T> Set<Set<T>> getSubsets(Set<Set<T>> powerSet, int size) {
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        for (Set<T> set : powerSet) {
            if (set.size() != size) continue;
            result.add(set);
        }
        return result;
    }

    public static <T> Set<Set<T>> powerSet(Set<T> originalSet) {
        logger.info((Object)("Starting with " + originalSet.size() + " unique properties ..."));
        HashSet<Set<T>> sets = new HashSet<Set<T>>();
        if (originalSet.isEmpty()) {
            sets.add(new HashSet());
            return sets;
        }
        ArrayList<T> list = new ArrayList<T>(originalSet);
        Object head = list.get(0);
        HashSet rest = new HashSet(list.subList(1, list.size()));
        for (Set set : Dofin.powerSet(rest)) {
            HashSet newSet = new HashSet();
            newSet.add(head);
            newSet.addAll(set);
            sets.add(newSet);
            sets.add(set);
        }
        return sets;
    }

    public static void main(String[] args) {
        HashSet<String> s1 = new HashSet<String>();
        s1.add("test1");
        s1.add("test2");
        HashSet<String> s2 = new HashSet<String>();
        s2.add("test1");
        s2.add("test2");
        s2.add("test3");
        s2.add("test4");
        Set<Set<String>> p1 = Dofin.generateInitialSetofSets(s2);
        p1 = Dofin.generateNextLevel(p1, 2);
        System.out.println(p1);
        p1 = Dofin.generateNextLevel(p1, 3);
        System.out.println(p1);
        p1 = Dofin.generateNextLevel(p1, 4);
        System.out.println(p1);
        Set<Set<String>> p = Dofin.powerSet(s2);
        System.out.println("P = " + p);
        System.out.println("Subsets of size 2 = " + Dofin.getSubsets(p, 2));
        p = Dofin.reduce(p, s1);
        System.out.println("Reduced P = " + p);
    }

    private static Set<Set<String>> generateNextLevel(Set<Set<String>> powerSet, int level) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        for (Set<String> s1 : powerSet) {
            for (Set<String> s2 : powerSet) {
                if (s1.equals(s2)) continue;
                HashSet<String> union = new HashSet<String>(s1);
                union.addAll(s2);
                if (union.size() != level) continue;
                result.add(union);
            }
            result.add(s1);
        }
        return result;
    }

    private static Set<Set<String>> generateInitialSetofSets(Set<String> properties) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        for (String p : properties) {
            HashSet<String> s = new HashSet<String>();
            s.add(p);
            result.add(s);
        }
        return result;
    }
}

