/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.dofin.algorithm;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.dofin.algorithm.DataFetcher;
import de.uni_leipzig.simba.dofin.algorithm.Dofin;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.atomic.EDJoin;
import de.uni_leipzig.simba.mapper.atomic.PPJoinPlusPlus;
import de.uni_leipzig.simba.mapper.atomic.TotalOrderBlockingMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSamplingFetcher
extends DataFetcher {
    public int sampleSize = 10;
    static Logger logger = Logger.getLogger("LIMES");
    HashMap<String, String> propertyIndex = new HashMap();
    HashMap<String, Set<String>> classToUriSample = new HashMap();

    public void getSample(String className, String endpoint, String graph) {
        HashSet<String> result = new HashSet<String>();
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT DISTINCT ?s\nWHERE { ?s rdf:type <" + className + "> } LIMIT " + this.sampleSize;
        try {
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = graph == null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery) : QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery, (String)graph);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                result.add(soln.get("s").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.classToUriSample.put(className, result);
    }

    @Override
    public Set<String> getClasses(String endpoint, String graph) {
        HashSet<String> result = new HashSet<String>();
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT DISTINCT ?x\nWHERE { ?s rdf:type ?x }";
        try {
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = graph == null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery) : QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery, (String)graph);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                result.add(soln.get("x").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Set<String> getProperties(String endpoint, String graph, String className) {
        HashSet<String> result = new HashSet<String>();
        this.propertyIndex = new HashMap();
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT DISTINCT ?x\nWHERE { ?s rdf:type <" + className + ">. \n" + "?s ?x ?o }";
        try {
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = graph == null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery) : QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery, (String)graph);
            ResultSet results = qexec.execSelect();
            int counter = 0;
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                String p = soln.get("x").toString();
                result.add(p);
                this.propertyIndex.put(p, "p" + counter);
                ++counter;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.remove("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        result.remove("http://www.w3.org/2002/07/owl#sameAs");
        return result;
    }

    @Override
    public Cache fillCache(String endpoint, String graph, String className, String property, Cache c) {
        if (this.propertyIndex.containsKey(property)) {
            if (!this.classToUriSample.containsKey(className)) {
                this.getSample(className, endpoint, graph);
            }
            Set<String> uris = this.classToUriSample.get(className);
            for (String uri : uris) {
                String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT DISTINCT ?o\nWHERE { <" + uri + "> <" + property + "> ?o }";
                try {
                    Query sparqlQuery = QueryFactory.create((String)query);
                    QueryExecution qexec = graph == null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery) : QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery, (String)graph);
                    ResultSet results = qexec.execSelect();
                    while (results.hasNext()) {
                        QuerySolution soln = results.nextSolution();
                        String o = soln.get("o").toString();
                        c.addTriple(uri, this.propertyIndex.get(property), o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return c;
    }

    @Override
    public Mapping getMapping(Cache source, String measure, String property, double threshold) {
        if (threshold >= 1.0) {
            threshold = 1.0 / (1.0 + threshold);
        }
        String expression = measure + "(x." + this.propertyIndex.get(property) + ", y." + this.propertyIndex.get(property) + ")";
        AtomicMapper mapper = measure.startsWith("leven") ? new EDJoin() : (measure.startsWith("euclid") ? new TotalOrderBlockingMapper() : new PPJoinPlusPlus());
        return mapper.getMapping(source, source, "?x", "?y", expression, threshold);
    }

    public static void main(String[] args) {
        String endpoint = "http://www4.wiwiss.fu-berlin.de/drugbank/sparql";
        String graph = null;
        DataSamplingFetcher df = new DataSamplingFetcher();
        Set<String> classes = df.getClasses(endpoint, graph);
        logger.info(classes.size() + " classes: " + classes);
        Iterator<String> i$ = classes.iterator();
        if (i$.hasNext()) {
            String c = i$.next();
            Set<String> properties = df.getProperties(endpoint, graph, c);
            HashMap<String, Mapping> mappings = new HashMap<String, Mapping>();
            System.out.println(df.propertyIndex);
            logger.info(properties.size() + " properties for class " + c);
            int counter = 0;
            Cache cache = new MemoryCache();
            for (String p : properties) {
                logger.info("Getting property " + p + " for class " + c + "...");
                cache = df.fillCache(endpoint, graph, c, p, cache);
                logger.info("Computing the corresponding mapping ...");
                Mapping m = df.getMapping(cache, "trigrams", p, 1.0);
                if (m.size > 0 && m != null) {
                    mappings.put(p, m);
                }
                if (++counter <= 9) continue;
                break;
            }
            ArrayList<String> uris = cache.getAllUris();
            logger.info("Running the Dofin algorithm");
            Set<Set<String>> result = Dofin.runScalable(mappings, uris);
            logger.info("Dofin returned the following set of properties: " + result);
            for (Set<String> p : result) {
                logger.info("Coverage of set " + p + " is " + df.getCoverage(p, cache));
            }
        }
    }

    @Override
    public double getCoverage(Set<String> properties, Cache cache) {
        ArrayList<String> uris = cache.getAllUris();
        double count = 0.0;
        block0: for (String uri : uris) {
            for (String property : properties) {
                String p = this.propertyIndex.get(property);
                if (cache.getInstance(uri).getProperty(p).isEmpty()) continue;
                count += 1.0;
                continue block0;
            }
        }
        return count / (double)uris.size();
    }
}

