/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.dofin.algorithm;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.dofin.algorithm.DataFetcher;
import de.uni_leipzig.simba.dofin.algorithm.DataSamplingFetcher;
import de.uni_leipzig.simba.dofin.algorithm.Dofin;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    static Logger logger = Logger.getLogger((String)"LIMES");
    Cache cache;
    Map<String, Set<Set<String>>> discriminativeProperties;
    HashMap<String, HashMap<String, Double>> coverageMap;

    public void writeToFile(HashMap<String, HashMap<String, Double>> result, String outputFile) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (String c : result.keySet()) {
                HashMap<String, Double> properties = result.get(c);
                for (String p : properties.keySet()) {
                    writer.println(c + "\t" + p + "\t" + properties.get(p));
                }
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, HashMap<String, Double>> getDiscriminativeProperties(String endpoint, String graph, int sampleSize) {
        this.discriminativeProperties = new HashMap<String, Set<Set<String>>>();
        HashMap<String, HashMap<String, Double>> output = new HashMap<String, HashMap<String, Double>>();
        try {
            DataSamplingFetcher df = new DataSamplingFetcher();
            df.sampleSize = sampleSize;
            Set<String> classes = df.getClasses(endpoint, graph);
            logger.info((Object)(classes.size() + " class for endpoint " + endpoint + " and graph " + graph));
            for (String c : classes) {
                HashMap<String, Double> pMap = new HashMap<String, Double>();
                Set<String> properties = df.getProperties(endpoint, graph, c);
                HashMap<String, Mapping> mappings = new HashMap<String, Mapping>();
                logger.info((Object)(properties.size() + " properties for class " + c));
                this.cache = new MemoryCache();
                for (String p : properties) {
                    logger.info((Object)("Getting property " + p + " for class " + c + "..."));
                    this.cache = df.fillCache(endpoint, graph, c, p, this.cache);
                    logger.info((Object)"Computing the corresponding LIMES mapping ...");
                    Mapping m = df.getMapping(this.cache, "levenshtein", p, 2.0);
                    if (m.size <= 0 || m == null) continue;
                    mappings.put(p, m);
                }
                ArrayList<String> uris = this.cache.getAllUris();
                logger.info((Object)"Running the Dofin algorithm");
                Set<Set<String>> result = Dofin.runScalable(mappings, uris);
                this.discriminativeProperties.put(c, result);
                logger.info((Object)("Dofin returned the following set of properties: " + result));
                for (Set<String> p : result) {
                    pMap.put(p + "", df.getCoverage(p, this.cache));
                }
                output.put(c, pMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.coverageMap = output;
        return output;
    }

    public HashMap<String, HashMap<String, Double>> getDiscriminativeProperties(String endpoint, String graph) {
        this.discriminativeProperties = new HashMap<String, Set<Set<String>>>();
        HashMap<String, HashMap<String, Double>> output = new HashMap<String, HashMap<String, Double>>();
        try {
            DataFetcher df = new DataFetcher();
            Set<String> classes = df.getClasses(endpoint, graph);
            logger.info((Object)(classes.size() + " class for endpoint " + endpoint + " and graph " + graph));
            for (String c : classes) {
                HashMap<String, Double> pMap = new HashMap<String, Double>();
                Set<String> properties = df.getProperties(endpoint, graph, c);
                HashMap<String, Mapping> mappings = new HashMap<String, Mapping>();
                logger.info((Object)(properties.size() + " properties for class " + c));
                this.cache = new MemoryCache();
                for (String p : properties) {
                    logger.info((Object)("Getting property " + p + " for class " + c + "..."));
                    this.cache = df.fillCache(endpoint, graph, c, p, this.cache);
                    System.out.println(this.cache);
                    logger.info((Object)"Computing the corresponding LIMES mapping ...");
                    Mapping m = df.getMapping(this.cache, "levenshtein", p, 2.0);
                    if (m.size <= 0 || m == null) continue;
                    mappings.put(p, m);
                }
                ArrayList<String> uris = this.cache.getAllUris();
                logger.info((Object)"Running the Dofin algorithm");
                Set<Set<String>> result = Dofin.runScalable(mappings, uris);
                logger.info((Object)("Dofin returned the following set of properties: " + result));
                this.discriminativeProperties.put(c, result);
                for (Set<String> p : result) {
                    pMap.put(p + "", df.getCoverage(p, this.cache));
                }
                output.put(c, pMap);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.coverageMap = output;
        return output;
    }

    public static void main(String[] args) {
        System.out.println("=========\n" + new Controller().getDiscriminativeProperties("http://live.dbpedia.org/sparql", null, 20));
    }
}

