/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.data;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.genetics.util.Pair;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMapping {
    Mapping base;
    TreeMap<Double, Pair<String>> sortedMapping;

    public SortedMapping(Mapping base) {
        this.base = base;
        this.sortedMapping = new TreeMap();
    }

    public TreeMap<Double, Pair<String>> sort() {
        this.sortBase();
        return this.sortedMapping;
    }

    private void sortBase() {
        for (String s1 : this.base.map.keySet()) {
            for (Map.Entry<String, Double> e2 : this.base.map.get(s1).entrySet()) {
                this.sortedMapping.put(e2.getValue(), new Pair<String>(s1, e2.getKey()));
            }
        }
    }

    public String toString() {
        String s = "";
        for (Map.Entry e : this.sortedMapping.descendingMap().entrySet()) {
            s = s + e.getKey() + " : " + e.getValue() + System.getProperty("line.separator");
        }
        return s;
    }

    public static void main(String[] args) {
        Mapping m = new Mapping();
        m.add("a", "b", 6.0);
        m.add("a", "c", 4.0);
        m.add("a", "d", 22.0);
        m.add("aa", "bb", 5.0);
        m.add("aaa", "bbb", 3.0);
        m.add("aaaa", "bbbb", 1.0);
        SortedMapping sortMap = new SortedMapping(m);
        sortMap.sort();
        System.out.println("Mapping:\n" + m);
        System.out.println("Sorted:\n" + sortMap);
    }
}

