/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.data;

import de.uni_leipzig.simba.execution.histogram.RandomStringGenerator;
import de.uni_leipzig.simba.io.Serializer;
import de.uni_leipzig.simba.io.SerializerFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    public HashMap<String, HashMap<String, Double>> map = new HashMap();
    public int size = 0;
    public HashMap<Double, HashMap<String, TreeSet<String>>> reversedMap;

    public int size() {
        return this.size;
    }

    public static Mapping generateRandomMapping(int mappingSize, int minSize, int maxSize) {
        Mapping m = new Mapping();
        RandomStringGenerator generator = new RandomStringGenerator(minSize, maxSize);
        while (m.getNumberofMappings() < mappingSize) {
            m.add(generator.generateString(), generator.generateString(), Math.random());
        }
        return m;
    }

    public void initReversedMap() {
        this.reversedMap = new HashMap();
        for (String s : this.map.keySet()) {
            for (String t : this.map.get(s).keySet()) {
                double sim = this.map.get(s).get(t);
                if (!this.reversedMap.containsKey(sim)) {
                    this.reversedMap.put(sim, new HashMap());
                }
                if (!this.reversedMap.get(sim).containsKey(s)) {
                    this.reversedMap.get(sim).put(s, new TreeSet());
                }
                this.reversedMap.get(sim).get(s).add(t);
            }
        }
    }

    public Mapping getSubMap(double threshold) {
        Mapping m = new Mapping();
        if (this.reversedMap == null) {
            this.initReversedMap();
        }
        for (Double d : this.reversedMap.keySet()) {
            if (!(d >= threshold)) continue;
            HashMap<String, TreeSet<String>> pairs = this.reversedMap.get(d);
            for (String s : pairs.keySet()) {
                for (String t : pairs.get(s)) {
                    m.add(s, t, d);
                }
            }
        }
        return m;
    }

    public void add(String uri, HashMap<String, Double> instances) {
        if (!this.map.containsKey(uri)) {
            this.map.put(uri, instances);
        } else {
            for (String mappingUri : instances.keySet()) {
                this.add(uri, mappingUri, instances.get(mappingUri));
                ++this.size;
            }
        }
    }

    public void add(String source, String target, double similarity) {
        if (this.map.containsKey(source)) {
            if (this.map.get(source).containsKey(target)) {
                if (similarity > this.map.get(source).get(target)) {
                    this.map.get(source).put(target, similarity);
                }
            } else {
                this.map.get(source).put(target, similarity);
            }
        } else {
            HashMap<String, Double> help = new HashMap<String, Double>();
            help.put(target, similarity);
            this.map.put(source, help);
        }
        ++this.size;
    }

    public double getSimilarity(String sourceInstance, String targetInstance) {
        if (this.map.containsKey(sourceInstance) && this.map.get(sourceInstance).containsKey(targetInstance)) {
            return this.map.get(sourceInstance).get(targetInstance);
        }
        return 0.0;
    }

    public boolean contains(String sourceInstance, String targetInstance) {
        return this.map.containsKey(sourceInstance) && this.map.get(sourceInstance).containsKey(targetInstance);
    }

    public String toString() {
        String s = "";
        for (String key : this.map.keySet()) {
            for (String value : this.map.get(key).keySet()) {
                s = s + "[" + key + " -> (" + value + "|" + this.map.get(key).get(value) + ")]\n";
            }
        }
        return s;
    }

    public int getNumberofMappings() {
        int size = 0;
        for (String s : this.map.keySet()) {
            HashMap<String, Double> m = this.map.get(s);
            size += m.size();
        }
        return size;
    }

    public Mapping getBestOneToNMapping() {
        Mapping result = new Mapping();
        for (String s : this.map.keySet()) {
            double maxSim = 0.0;
            HashSet<String> target = new HashSet<String>();
            for (String t : this.map.get(s).keySet()) {
                if (this.getSimilarity(s, t) == maxSim) {
                    target.add(t);
                }
                if (!(this.getSimilarity(s, t) > maxSim)) continue;
                maxSim = this.getSimilarity(s, t);
                target = new HashSet();
                target.add(t);
            }
            for (String t : target) {
                result.add(s, t, maxSim);
            }
        }
        return result;
    }

    public Mapping reverseSourceTarget() {
        Mapping m = new Mapping();
        for (String s : this.map.keySet()) {
            for (String t : this.map.get(s).keySet()) {
                m.add(t, s, this.map.get(s).get(t));
            }
        }
        return m;
    }

    public static Mapping getBestOneToOneMappings(Mapping m) {
        Mapping m2 = m.getBestOneToNMapping();
        m2 = m2.reverseSourceTarget();
        m2 = m2.getBestOneToNMapping();
        m2 = m2.reverseSourceTarget();
        return m2;
    }

    public static Mapping readNtFile(String file) {
        Mapping m = new Mapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String s = reader.readLine();
            while (s != null) {
                String[] split = s.split(" ");
                m.add(split[0].substring(1, split[0].length() - 1), split[2].substring(1, split[2].length() - 1), 1.0);
                s = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Mapping readFromCsvFile(String file) {
        Mapping m = new Mapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String s = reader.readLine();
            while (s != null) {
                String[] split = s.split("\t");
                m.add(split[0].substring(1, split[0].length() - 1), split[1].substring(1, split[1].length() - 1), 1.0);
                s = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Mapping readThreeColumnFile(String file) {
        Mapping m = new Mapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String s = reader.readLine();
            while (s != null) {
                String[] split = s.split("\t");
                m.add(split[0].substring(1, split[0].length() - 1), split[1].substring(1, split[1].length() - 1), Double.parseDouble(split[2]));
                s = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public static void main(String[] args) {
        Mapping m = new Mapping();
        m = Mapping.readThreeColumnFile("E:/tmp/tabicdguo.nt");
        m = Mapping.getBestOneToOneMappings(m);
        Serializer ser = SerializerFactory.getSerializer("TAB");
        ser.writeToFile(m, "owl:sameAs", "E:/tmp/tabicdguo_sorted.nt");
    }
}

