/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instance
implements Comparable,
Serializable {
    private static final long serialVersionUID = -8613951110508439148L;
    private String uri;
    private HashMap<String, TreeSet<String>> properties;
    public double distance;

    public Instance(String _uri) {
        this.uri = _uri;
        this.properties = new HashMap();
        this.distance = -1.0;
    }

    public void addProperty(String propUri, String value) {
        if (this.properties.containsKey(propUri)) {
            this.properties.get(propUri).add(value);
        } else {
            TreeSet<String> values = new TreeSet<String>();
            values.add(value);
            this.properties.put(propUri, values);
        }
    }

    public void addProperty(String propUri, TreeSet<String> values) {
        if (this.properties.containsKey(propUri)) {
            Iterator<String> iter = values.iterator();
            while (iter.hasNext()) {
                this.properties.get(propUri).add(iter.next());
            }
        } else {
            this.properties.put(propUri, values);
        }
    }

    public void replaceProperty(String propUri, TreeSet<String> values) {
        if (this.properties.containsKey(propUri)) {
            this.properties.remove(propUri);
        }
        this.addProperty(propUri, values);
    }

    public String getUri() {
        return this.uri;
    }

    public TreeSet<String> getProperty(String propUri) {
        if (this.properties.containsKey(propUri)) {
            return this.properties.get(propUri);
        }
        Logger logger = Logger.getLogger((String)"LIMES");
        logger.warn((Object)("Failed to access property <" + propUri + "> on " + this.uri));
        return new TreeSet<String>();
    }

    public Set<String> getAllProperties() {
        return this.properties.keySet();
    }

    public String toString() {
        String s = this.uri;
        for (String propUri : this.properties.keySet()) {
            s = s + "; " + "\n" + propUri + " -> " + this.properties.get(propUri);
        }
        return s + "; distance = " + this.distance + "\n";
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(Instance.class)) {
            return -1;
        }
        double diff = this.distance - ((Instance)o).distance;
        if (diff < 0.0) {
            return 1;
        }
        if (diff > 0.0) {
            return -1;
        }
        return ((Instance)o).uri.compareTo(this.uri);
    }
}

