/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.controller;

import algorithms.Correspondence;
import algorithms.ppjoinplus.PPJoinPlus;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.controller.Controller;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.io.serializer.TabSeparatedSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class SimpleSimilarityPPJoinController
extends Controller {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static void main(String[] args) {
        if (new File(args[0]).exists()) {
            SimpleSimilarityPPJoinController.run(args[0]);
        } else {
            logger.fatal((Object)("Input file " + args[0] + " does not exist."));
            System.exit(1);
        }
    }

    public static void run(String configFile) {
        Instance instance;
        long startTime = System.currentTimeMillis();
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        logger.setLevel(Level.DEBUG);
        ConfigReader cr = new ConfigReader();
        cr.validateAndRead(configFile);
        logger.info((Object)cr.getSourceInfo());
        logger.info((Object)cr.getTargetInfo());
        logger.info((Object)"Loading source data ...");
        HybridCache source = new HybridCache();
        source = SimpleSimilarityPPJoinController.getData(cr.getSourceInfo());
        logger.info((Object)"Loading target data ...");
        HybridCache target = new HybridCache();
        target = SimpleSimilarityPPJoinController.getData(cr.getTargetInfo());
        if (target.size() > source.size()) {
            logger.info((Object)"Swapping data sources as |T| > |S|");
            HybridCache help = target;
            target = source;
            source = help;
            KBInfo swap = cr.sourceInfo;
            cr.sourceInfo = cr.targetInfo;
            cr.targetInfo = swap;
        }
        char metricName = cr.metricExpression.charAt(0);
        logger.info((Object)"Filling objects from source knowledge base.");
        HashMap<Integer, String> sourceMap = new HashMap<Integer, String>();
        ArrayList<String> uris = source.getAllUris();
        ArrayList<String> entries = new ArrayList<String>();
        int counter = 0;
        int border = 0;
        for (int i = 0; i < uris.size(); ++i) {
            instance = source.getInstance(uris.get(i));
            for (String s : instance.getProperty(cr.sourceInfo.properties.get(0))) {
                sourceMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        logger.info((Object)"Filling objects from target knowledge base.");
        HashMap<Integer, String> targetMap = new HashMap<Integer, String>();
        border = counter - 1;
        uris = target.getAllUris();
        for (int i = 0; i < uris.size(); ++i) {
            instance = target.getInstance(uris.get(i));
            for (String s : instance.getProperty(cr.targetInfo.properties.get(0))) {
                targetMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        String[] entryArray = new String[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            entryArray[i] = (String)entries.get(i);
        }
        logger.info((Object)"Launching PPJoinX");
        LinkedList result = PPJoinPlus.start((char)metricName, (double)cr.verificationThreshold, (int)2, (String[])entryArray);
        logger.info((Object)"PPJoinX complete.");
        logger.info((Object)"Beginning to serialize results ...");
        TabSeparatedSerializer serializer = new TabSeparatedSerializer();
        Mapping accepted = new Mapping();
        Mapping toReview = new Mapping();
        logger.info((Object)("Mapping carried out in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        logger.info((Object)"Done.");
        for (int i = 0; i < result.size(); ++i) {
            Correspondence corr;
            if ((i + 1) % 1000 == 0) {
                logger.info((Object)("Serialized " + i * 100 / result.size() + "% of the results"));
            }
            if (((corr = (Correspondence)result.get(i)).getFirstObject() > border || corr.getSecondObject() <= border) && (corr.getFirstObject() <= border || corr.getSecondObject() > border)) continue;
            if (corr.getSimilarity() >= cr.acceptanceThreshold) {
                if (corr.getFirstObject() <= border) {
                    accepted.add((String)sourceMap.get(corr.getFirstObject()), (String)targetMap.get(corr.getSecondObject()), corr.getSimilarity());
                    continue;
                }
                accepted.add((String)sourceMap.get(corr.getSecondObject()), (String)targetMap.get(corr.getFirstObject()), corr.getSimilarity());
                continue;
            }
            if (corr.getFirstObject() <= border) {
                toReview.add((String)sourceMap.get(corr.getFirstObject()), (String)targetMap.get(corr.getSecondObject()), corr.getSimilarity());
                continue;
            }
            toReview.add((String)sourceMap.get(corr.getSecondObject()), (String)targetMap.get(corr.getFirstObject()), corr.getSimilarity());
        }
        serializer.writeToFile(accepted, cr.acceptanceRelation, cr.acceptanceFile);
        serializer.writeToFile(toReview, cr.verificationRelation, cr.verificationFile);
        logger.info((Object)"Serialize completed");
        logger.info((Object)("Required " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds overall."));
        logger.info((Object)"Done.");
    }
}

