/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.controller;

import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;

public class SetConstraintsController {
    public Mapping getLinks(String expression, double threshold) {
        Mapping map = new Mapping();
        Parser p = new Parser(expression, threshold);
        if (!p.isAtomic()) {
            Mapping map1 = this.getLinks(p.term1, p.threshold1);
            Mapping map2 = this.getLinks(p.term2, p.threshold1);
            map = p.op.equals("add") ? this.mergeMaps(p.op, map1, map2, expression, threshold) : this.mergeMaps(p.op, map1, map2, null, threshold);
        }
        return map;
    }

    public Mapping mergeMaps(String operation, Mapping map1, Mapping map2, String condition, double threshold) {
        Mapping map = new Mapping();
        if (operation.equals("max") || operation.equals("or")) {
            map = SetConstraintsController.union(map1, map2);
        } else if (operation.equals("and") || operation.equals("min")) {
            map = SetConstraintsController.intersection(map1, map2);
        } else if (operation.equals("minus")) {
            map = SetConstraintsController.difference(map1, map2);
        } else if (operation.equals("xor")) {
            map = SetConstraintsController.union(SetConstraintsController.difference(map1, map2), SetConstraintsController.difference(map2, map1));
        } else if (operation.equals("add")) {
            map = SetConstraintsController.union(map1, map2);
        }
        return map;
    }

    public static Mapping difference(Mapping map1, Mapping map2) {
        Mapping map = new Mapping();
        for (String key : map1.map.keySet()) {
            if (map2.map.containsKey(key)) {
                for (String value : map1.map.get(key).keySet()) {
                    if (map2.map.get(key).containsKey(value)) continue;
                    map.add(key, value, map1.map.get(key).get(value));
                }
                continue;
            }
            map.add(key, map1.map.get(key));
        }
        return map;
    }

    public static Mapping intersection(Mapping map1, Mapping map2) {
        Mapping map = new Mapping();
        for (String key : map1.map.keySet()) {
            if (!map2.map.containsKey(key)) continue;
            for (String value : map1.map.get(key).keySet()) {
                if (!map2.map.get(key).containsKey(value)) continue;
                if (map1.map.get(key).get(value) <= map2.map.get(key).get(value)) {
                    map.add(key, value, map1.map.get(key).get(value));
                    continue;
                }
                map.add(key, value, map2.map.get(key).get(value));
            }
        }
        return map;
    }

    public static Mapping union(Mapping map1, Mapping map2) {
        Mapping map = new Mapping();
        for (String key : map1.map.keySet()) {
            if (map2.map.containsKey(key)) {
                for (String value : map1.map.get(key).keySet()) {
                    if (map2.map.get(key).keySet().contains(value)) {
                        if (map1.map.get(key).get(value) >= map2.map.get(key).get(value)) {
                            map.add(key, value, map1.map.get(key).get(value));
                            continue;
                        }
                        map.add(key, value, map2.map.get(key).get(value));
                        continue;
                    }
                    map.add(key, value, map1.map.get(key).get(value));
                }
                continue;
            }
            map.add(key, map1.map.get(key));
        }
        for (String key : map2.map.keySet()) {
            for (String value : map2.map.get(key).keySet()) {
                if (map.map.keySet().contains(key)) {
                    if (map.map.get(key).containsKey(value)) continue;
                    map.add(key, value, map2.map.get(key).get(value));
                    continue;
                }
                map.add(key, map2.map.get(key));
            }
        }
        return map;
    }

    public static Mapping min(Mapping map1, Mapping map2) {
        Mapping map = new Mapping();
        for (String key : map1.map.keySet()) {
            if (map2.map.containsKey(key)) {
                for (String value : map1.map.get(key).keySet()) {
                    if (map2.map.get(key).keySet().contains(value)) {
                        if (map1.map.get(key).get(value) <= map2.map.get(key).get(value)) {
                            map.add(key, value, map1.map.get(key).get(value));
                            continue;
                        }
                        map.add(key, value, map2.map.get(key).get(value));
                        continue;
                    }
                    map.add(key, value, map1.map.get(key).get(value));
                }
                continue;
            }
            map.add(key, map1.map.get(key));
        }
        for (String key : map2.map.keySet()) {
            for (String value : map2.map.get(key).keySet()) {
                if (map.map.keySet().contains(key)) {
                    if (map.map.get(key).containsKey(value)) continue;
                    map.add(key, value, map2.map.get(key).get(value));
                    continue;
                }
                map.add(key, map2.map.get(key));
            }
        }
        return map;
    }

    public static void main(String[] args) {
        Mapping m1 = new Mapping();
        m1.add("a", "b", 0.5);
        m1.add("a", "c", 0.4f);
        m1.add("b", "d", 0.4f);
        Mapping m2 = new Mapping();
        m2.add("a", "b", 0.6f);
        m2.add("f", "g", 0.5);
        m2.add("b", "e", 0.5);
        Mapping m = SetConstraintsController.union(SetConstraintsController.difference(m1, m2), SetConstraintsController.difference(m2, m1));
        for (String key : m.map.keySet()) {
            System.out.println(key + " -> " + m.map.get(key));
        }
    }
}

