/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.controller;

import org.apache.log4j.Logger;

public class Parser {
    static Logger logger = Logger.getLogger((String)"LIMES");
    String expression;
    public String term1;
    public String term2;
    public String op;
    public double threshold;
    public double threshold1;
    public double threshold2;
    public double coef1;
    public double coef2;

    public Parser(String input, double theta) {
        this.expression = input.replaceAll(" ", "");
        this.threshold = theta;
        this.getTerms();
    }

    public boolean isAtomic() {
        String copy = this.expression.toLowerCase();
        return !copy.contains("max(") && !copy.contains("min(") && !copy.contains("and(") && !copy.contains("or(") && !copy.contains("add(") && !copy.contains("xor(") && !copy.contains("minus(") && !copy.contains("mult(");
    }

    public String getTerm1() {
        return this.term1;
    }

    public String getOperation() {
        return this.op;
    }

    public String getTerm2() {
        return this.term2;
    }

    public void getCoef1() {
        this.coef1 = 1.0;
        if (this.term1.contains("*")) {
            String[] split = this.term1.split("\\*");
            try {
                this.coef1 = Double.parseDouble(split[0]);
                this.term1 = split[1];
            }
            catch (Exception e) {
                logger.warn((Object)("Error parsing " + this.term1 + " for coefficient <" + this.coef1 + ">"));
                this.coef1 = 1.0;
            }
        }
    }

    public void getCoef2() {
        this.coef2 = 1.0;
        if (this.term2.contains("*")) {
            String[] split = this.term2.split("\\*");
            try {
                this.coef2 = Double.parseDouble(split[0]);
                this.term2 = split[1];
            }
            catch (Exception e) {
                this.coef2 = 1.0;
                logger.warn((Object)("Error parsing " + this.term2 + " for coefficient"));
            }
        }
    }

    public void getTerms() {
        if (!this.isAtomic()) {
            int counter = 1;
            boolean found = false;
            this.op = this.expression.substring(0, this.expression.indexOf("("));
            String noOpExpression = this.expression.substring(this.expression.indexOf("(") + 1, this.expression.lastIndexOf(")"));
            for (int i = 0; i < noOpExpression.length(); ++i) {
                if (noOpExpression.charAt(i) == '(') {
                    ++counter;
                    found = true;
                    continue;
                }
                if (noOpExpression.charAt(i) == ')') {
                    --counter;
                    found = true;
                    continue;
                }
                if (counter != 1 || !found || noOpExpression.charAt(i) != ',') continue;
                this.term1 = noOpExpression.substring(0, i);
                this.term2 = noOpExpression.substring(i + 1);
            }
            this.getCoef1();
            this.getCoef2();
            if (this.op.equalsIgnoreCase("MIN") || this.op.equalsIgnoreCase("MAX")) {
                this.threshold1 = this.threshold;
                this.threshold2 = this.threshold;
            } else if (this.op.equalsIgnoreCase("ADD")) {
                this.op = "ADD";
                System.out.println("Coef1 = " + this.coef1 + ", Coef2 = " + this.coef2);
                this.threshold1 = (this.threshold - this.coef2) / this.coef1;
                this.threshold2 = (this.threshold - this.coef1) / this.coef2;
            } else if (this.op.equalsIgnoreCase("MULT")) {
                this.op = "MULT";
                this.threshold2 = this.threshold1 = this.threshold / (this.coef2 * this.coef1);
            } else {
                int index = this.term1.lastIndexOf("|");
                String set1 = this.term1.substring(0, index);
                String t = this.term1.substring(index + 1, this.term1.length());
                this.threshold1 = Double.parseDouble(t);
                this.term1 = set1;
                index = this.term2.lastIndexOf("|");
                String set2 = this.term2.substring(0, index);
                t = this.term2.substring(index + 1, this.term2.length());
                this.threshold2 = Double.parseDouble(t);
                this.term2 = set2;
            }
        } else {
            this.op = this.expression.substring(0, this.expression.indexOf("("));
            String noOpExpression = this.expression.substring(this.expression.indexOf("(") + 1, this.expression.lastIndexOf(")"));
            String[] split = noOpExpression.split(",");
            this.term1 = split[0];
            this.term2 = split[1];
        }
    }

    public static void testParsing(String s, double threshold) {
        Parser p = new Parser(s, threshold);
        if (p.isAtomic()) {
            System.out.println("-->" + s + " with threshold " + threshold + " will be carried out.");
        } else {
            Parser.testParsing(p.term1, p.threshold1);
            Parser.testParsing(p.term2, p.threshold2);
        }
    }

    public static void main(String[] args) {
        String m = "levenshtein(x.http://www.okkam.org/ontology_person1.owl#surname, y.http://www.okkam.org/ontology_person2.owl#surname)";
        m = "OR(A|0.8,B|0.7)";
        Parser p = new Parser(m, 0.5);
        System.out.println(p.isAtomic());
        Parser.testParsing(m, 0.5);
        System.out.println(p.op);
        System.out.println(p.term1);
        System.out.println(p.term2);
    }
}

