/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.controller;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.Serializer;
import de.uni_leipzig.simba.io.SerializerFactory;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class PPJoinController {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static void main(String[] args) {
        if (args.length == 0) {
            logger.fatal((Object)"No configuration file specified.");
            System.exit(1);
        }
        if (new File(args[0]).exists()) {
            PPJoinController.run(args[0]);
        } else {
            logger.fatal((Object)("Input file " + args[0] + " does not exist."));
            System.exit(1);
        }
    }

    public static Mapping getMapping(String configFile) {
        long startTime = System.currentTimeMillis();
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        logger.setLevel(Level.DEBUG);
        ConfigReader cr = new ConfigReader();
        cr.validateAndRead(configFile);
        logger.info((Object)cr.getSourceInfo());
        logger.info((Object)cr.getTargetInfo());
        logger.info((Object)"Loading source data ...");
        HybridCache source = new HybridCache();
        source = HybridCache.getData(cr.getSourceInfo());
        logger.info((Object)"Loading target data ...");
        HybridCache target = new HybridCache();
        target = HybridCache.getData(cr.getTargetInfo());
        SetConstraintsMapper mapper = SetConstraintsMapperFactory.getMapper(cr.executionPlan, cr.sourceInfo, cr.targetInfo, source, target, new LinearFilter(), cr.granularity);
        logger.info((Object)"Getting links ...");
        long time = System.currentTimeMillis();
        Mapping mapping = mapper.getLinks(cr.metricExpression, cr.verificationThreshold);
        logger.info((Object)("Got links in " + (System.currentTimeMillis() - time) + "ms."));
        return mapping;
    }

    public static void run(String configFile) {
        long startTime = System.currentTimeMillis();
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        logger.setLevel(Level.DEBUG);
        ConfigReader cr = new ConfigReader();
        cr.validateAndRead(configFile);
        logger.info((Object)cr.getSourceInfo());
        logger.info((Object)cr.getTargetInfo());
        logger.info((Object)"Loading source data ...");
        HybridCache source = HybridCache.getData(cr.getSourceInfo());
        logger.info((Object)"Loading target data ...");
        HybridCache target = HybridCache.getData(cr.getTargetInfo());
        SetConstraintsMapper mapper = SetConstraintsMapperFactory.getMapper(cr.executionPlan, cr.sourceInfo, cr.targetInfo, source, target, new LinearFilter(), cr.granularity);
        logger.info((Object)"Getting links ...");
        long time = System.currentTimeMillis();
        Mapping mapping = mapper.getLinks(cr.metricExpression, cr.verificationThreshold);
        logger.info((Object)("Got links in " + (System.currentTimeMillis() - time) + "ms."));
        Serializer serializer = SerializerFactory.getSerializer(cr.outputFormat);
        File f = new File(configFile).getAbsoluteFile().getParentFile().getAbsoluteFile();
        serializer.setFolderPath(f);
        logger.info((Object)("Using " + serializer.getName() + " to serialize"));
        Mapping accepted = new Mapping();
        Mapping toReview = new Mapping();
        int linkCounter = 0;
        int reviewCounter = 0;
        for (String key : mapping.map.keySet()) {
            for (String value : mapping.map.get(key).keySet()) {
                if (mapping.map.get(key).get(value) >= cr.acceptanceThreshold) {
                    ++linkCounter;
                    accepted.add(key, value, mapping.map.get(key).get(value));
                    continue;
                }
                if (!(mapping.map.get(key).get(value) >= cr.verificationThreshold)) continue;
                ++reviewCounter;
                toReview.add(key, value, mapping.map.get(key).get(value));
            }
        }
        logger.info((Object)("Returned " + linkCounter + " links above acceptance threshold."));
        logger.info((Object)("Returned " + reviewCounter + " links to review."));
        serializer.setPrefixes(cr.prefixes);
        serializer.writeToFile(accepted, cr.acceptanceRelation, cr.acceptanceFile);
        serializer.writeToFile(toReview, cr.verificationRelation, cr.verificationFile);
        logger.info((Object)("Mapping carried out in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        logger.info((Object)"Done.");
    }
}

