/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.controller;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.genetics.evaluation.Tester;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.io.Serializer;
import de.uni_leipzig.simba.io.SerializerFactory;
import de.uni_leipzig.simba.metricfactory.SimpleMetricFactory;
import de.uni_leipzig.simba.organizer.DensityBasedOrganizer;
import de.uni_leipzig.simba.query.QueryModule;
import de.uni_leipzig.simba.query.QueryModuleFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Controller {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static void main(String[] args) {
        if (args.length == 0) {
            String configFile = "Examples/GeneticEval/dbpedia-linkedmdb.xml";
            Controller.run(configFile);
            ConfigReader cR = new ConfigReader();
            cR.validateAndRead(configFile);
            Tester.run(cR);
        } else if (new File(args[0]).exists()) {
            Controller.run(args[0]);
        } else {
            System.exit(1);
        }
    }

    public static void run(String configFile) {
        int size = 0;
        long startTime = System.currentTimeMillis();
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        logger.setLevel(Level.DEBUG);
        ConfigReader cr = new ConfigReader();
        cr.validateAndRead(configFile);
        logger.info((Object)cr.getSourceInfo());
        logger.info((Object)cr.getTargetInfo());
        logger.info((Object)"Loading source data ...");
        HybridCache source = Controller.getData(cr.getSourceInfo());
        logger.info((Object)"Loading target data ...");
        HybridCache target = Controller.getData(cr.getTargetInfo());
        if (source.size() == 0) {
            logger.info((Object)"Source is empty - nothing to do");
            return;
        }
        if (target.size() == 0) {
            logger.info((Object)"Target is empty - nothing to do");
            return;
        }
        if (target.size() > source.size()) {
            logger.info((Object)"Swapping data sources as |T| > |S|");
            HybridCache help = target;
            target = source;
            source = help;
            KBInfo swap = cr.sourceInfo;
            cr.sourceInfo = cr.targetInfo;
            cr.targetInfo = swap;
        }
        SimpleMetricFactory mf = new SimpleMetricFactory(cr.sourceInfo.var, cr.targetInfo.var);
        mf.setExpression(cr.metricExpression);
        logger.info((Object)("Comparisons will be carried out by using " + cr.metricExpression));
        SimpleMetricFactory organizerMf = new SimpleMetricFactory(cr.sourceInfo.var, cr.targetInfo.var);
        String var1 = cr.sourceInfo.var.replaceAll("\\?", "");
        String var2 = cr.targetInfo.var.replaceAll("\\?", "");
        organizerMf.setExpression(mf.foldExpression(cr.metricExpression, var2, var1));
        logger.info((Object)("Organizing will be carried out by using " + mf.foldExpression(cr.metricExpression, var2, var1)));
        DensityBasedOrganizer organizer = new DensityBasedOrganizer();
        if (cr.exemplars < 2) {
            logger.info((Object)"Exemplars < 2: Automatically choosing size");
            organizer.computeExemplars(target, organizerMf);
        } else {
            organizer.computeExemplars(target, organizerMf, cr.exemplars);
        }
        ArrayList<String> uris = source.getAllUris();
        logger.info((Object)"Ready to compare.");
        Mapping acceptedLinks = new Mapping();
        Mapping linksToReview = new Mapping();
        Serializer serializer = SerializerFactory.getSerializer(cr.outputFormat);
        for (int i = 0; i < uris.size(); ++i) {
            if ((i + 1) % 1000 == 0) {
                logger.info((Object)(i * 100 / uris.size() + "% of links computed ..."));
            }
            HashMap<String, Double> results = organizer.getSimilarInstances(source.getInstance(uris.get(i)), cr.verificationThreshold, mf);
            for (String s : results.keySet()) {
                if (results.get(s) >= cr.acceptanceThreshold) {
                    acceptedLinks.add(uris.get(i), s, results.get(s));
                    ++size;
                    continue;
                }
                if (!(results.get(s) >= cr.verificationThreshold)) continue;
                linksToReview.add(uris.get(i), s, results.get(s));
            }
        }
        serializer.writeToFile(acceptedLinks, cr.acceptanceRelation, cr.acceptanceFile);
        serializer.writeToFile(linksToReview, cr.verificationRelation, cr.verificationFile);
        logger.info((Object)("Required " + organizer.getComparisons() + " comparisons overall.\n"));
        logger.info((Object)("Comparisons were carried out in " + organizer.getComparisonTime() + " seconds overall.\n"));
        logger.info((Object)("Required " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds overall."));
        System.out.println("Mapping size = " + size);
        logger.info((Object)"Done.");
    }

    public static HybridCache getData(KBInfo kb) {
        HybridCache cache = new HybridCache();
        File cacheFile = new File("cache/" + kb.hashCode() + ".ser");
        try {
            if (cacheFile.exists()) {
                logger.info((Object)("Found cached data. Loading data from file " + cacheFile.getAbsolutePath()));
                cache = HybridCache.loadFromFile(cacheFile);
            }
            if (cache.size() == 0) {
                throw new Exception();
            }
            logger.info((Object)("Cached data loaded successfully from file " + cacheFile.getAbsolutePath()));
            logger.info((Object)("Size = " + cache.size()));
        }
        catch (Exception e) {
            logger.info((Object)("No cached data found for " + kb.id));
            QueryModule module = QueryModuleFactory.getQueryModule(kb.type, kb);
            module.fillCache(cache);
            if (!new File("cache").exists() || !new File("cache").isDirectory()) {
                new File("cache").mkdir();
            }
            cache.saveToFile(new File("cache/" + kb.hashCode() + ".ser"));
        }
        return cache;
    }
}

