/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.cache;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.preprocessing.Preprocessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCache
implements Cache {
    HashMap<String, Instance> instanceMap = new HashMap();
    Iterator<Instance> instanceIterator;

    @Override
    public Instance getNextInstance() {
        if (this.instanceIterator.hasNext()) {
            return this.instanceIterator.next();
        }
        return null;
    }

    @Override
    public ArrayList<Instance> getAllInstances() {
        return new ArrayList<Instance>(this.instanceMap.values());
    }

    @Override
    public void addInstance(Instance i) {
        if (this.instanceMap.containsKey(i.getUri())) {
            Instance instance = this.instanceMap.get(i.getUri());
        } else {
            this.instanceMap.put(i.getUri(), i);
        }
    }

    @Override
    public Instance getInstance(String uri) {
        if (this.instanceMap.containsKey(uri)) {
            return this.instanceMap.get(uri);
        }
        return null;
    }

    @Override
    public int size() {
        return this.instanceMap.size();
    }

    @Override
    public void addTriple(String s, String p, String o) {
        if (this.instanceMap.containsKey(s)) {
            Instance m = this.instanceMap.get(s);
            m.addProperty(p, o);
        } else {
            Instance m = new Instance(s);
            m.addProperty(p, o);
            this.instanceMap.put(s, m);
        }
    }

    @Override
    public boolean containsInstance(Instance i) {
        return this.instanceMap.containsKey(i.getUri());
    }

    @Override
    public boolean containsUri(String uri) {
        return this.instanceMap.containsKey(uri);
    }

    @Override
    public void resetIterator() {
        this.instanceIterator = this.instanceMap.values().iterator();
    }

    public String toString() {
        return this.instanceMap.toString();
    }

    @Override
    public ArrayList<String> getAllUris() {
        return new ArrayList<String>(this.instanceMap.keySet());
    }

    @Override
    public Cache getSample(int size) {
        MemoryCache c = new MemoryCache();
        ArrayList<String> uris = this.getAllUris();
        while (c.size() < size) {
            int index = (int)Math.floor(Math.random() * (double)this.size());
            Instance i = this.getInstance(uris.get(index));
            c.addInstance(i);
        }
        return c;
    }

    @Override
    public Cache processData(String processingChain) {
        MemoryCache c = new MemoryCache();
        for (Instance instance : this.getAllInstances()) {
            String uri = instance.getUri();
            for (String p : instance.getAllProperties()) {
                for (String value : instance.getProperty(p)) {
                    c.addTriple(uri, p, Preprocessor.process(value, processingChain));
                }
            }
        }
        return c;
    }

    public static void main(String[] args) {
        Cache c = new MemoryCache();
        c.addTriple("#1", "p", "Test@en");
        c.addTriple("#1", "p", "Test");
        c.addTriple("#2", "p", "Test21@en");
        c.addTriple("#2", "p", "Test22@en");
        c.addTriple("#2", "q", "Test23@en");
        c = c.processData("nolang->lowercase");
        System.out.println(c);
    }
}

