/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.cache;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.preprocessing.Preprocessor;
import de.uni_leipzig.simba.query.NoPrefixSparqlQueryModule;
import de.uni_leipzig.simba.query.QueryModule;
import de.uni_leipzig.simba.query.QueryModuleFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridCache
extends MemoryCache
implements Serializable {
    private static final long serialVersionUID = -2268344215686055231L;
    HashMap<String, Instance> instanceMap;
    Iterator<Instance> instanceIterator;
    static Logger logger = Logger.getLogger((String)"LIMES");
    private File folder = new File("");

    public HybridCache() {
        this.instanceMap = new HashMap();
    }

    public HybridCache(File folder) {
        this();
        this.setFolder(folder);
    }

    @Override
    public Instance getNextInstance() {
        if (this.instanceIterator == null) {
            this.instanceIterator = this.instanceMap.values().iterator();
        }
        if (this.instanceIterator.hasNext()) {
            return this.instanceIterator.next();
        }
        return null;
    }

    @Override
    public ArrayList<Instance> getAllInstances() {
        return new ArrayList<Instance>(this.instanceMap.values());
    }

    @Override
    public void addInstance(Instance i) {
        if (!this.instanceMap.containsKey(i.getUri())) {
            this.instanceMap.put(i.getUri(), i);
        }
    }

    @Override
    public Instance getInstance(String uri) {
        if (this.instanceMap.containsKey(uri)) {
            return this.instanceMap.get(uri);
        }
        return null;
    }

    @Override
    public int size() {
        return this.instanceMap.size();
    }

    @Override
    public void addTriple(String s, String p, String o) {
        if (this.instanceMap.containsKey(s)) {
            Instance m = this.instanceMap.get(s);
            m.addProperty(p, o);
        } else {
            Instance m = new Instance(s);
            m.addProperty(p, o);
            this.instanceMap.put(s, m);
        }
    }

    @Override
    public boolean containsInstance(Instance i) {
        return this.instanceMap.containsKey(i.getUri());
    }

    @Override
    public boolean containsUri(String uri) {
        return this.instanceMap.containsKey(uri);
    }

    @Override
    public void resetIterator() {
        this.instanceIterator = this.instanceMap.values().iterator();
    }

    @Override
    public String toString() {
        return this.instanceMap.toString();
    }

    @Override
    public ArrayList<String> getAllUris() {
        return new ArrayList<String>(this.instanceMap.keySet());
    }

    public void saveToFile(File file) {
        Logger logger = Logger.getLogger((String)"LIMES");
        logger.info((Object)("Serializing " + this.size() + " objects to " + file.getAbsolutePath()));
        try {
            FileOutputStream out = new FileOutputStream(file);
            ObjectOutputStream serializer = new ObjectOutputStream(out);
            serializer.writeObject(this);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            file.delete();
        }
    }

    public static HybridCache loadFromFile(File file) throws IOException {
        String path = file.getAbsolutePath();
        String parentPath = path.substring(0, path.lastIndexOf("cache"));
        File parent = new File(parentPath);
        FileInputStream in = new FileInputStream(file);
        ObjectInputStream deSerializer = new ObjectInputStream(in);
        try {
            HybridCache cache = (HybridCache)deSerializer.readObject();
            cache.setFolder(parent);
            HybridCache hybridCache = cache;
            return hybridCache;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            in.close();
        }
    }

    public static HybridCache getData(KBInfo kb) {
        return HybridCache.getData(new File(""), kb);
    }

    public static HybridCache getData(File folder, KBInfo kb) {
        HybridCache cache = new HybridCache(folder);
        File cacheFile = new File(folder.getAbsolutePath() + File.separatorChar + "cache/" + kb.hashCode() + ".ser");
        try {
            if (cacheFile.exists()) {
                logger.info((Object)("Found cached data. Loading data from file " + cacheFile.getAbsolutePath()));
                cache = HybridCache.loadFromFile(cacheFile);
            }
            if (cache.size() == 0) {
                throw new Exception();
            }
            logger.info((Object)("Cached data loaded successfully from file " + cacheFile.getAbsolutePath()));
            logger.info((Object)("Size = " + cache.size()));
        }
        catch (Exception e) {
            logger.info((Object)("No cached data found for " + kb.id));
            QueryModule module = QueryModuleFactory.getQueryModule(kb.type, kb);
            module.fillCache(cache);
            if (!new File(folder.getAbsolutePath() + File.separatorChar + "cache").exists() || !new File(folder.getAbsolutePath() + File.separatorChar + "cache").isDirectory()) {
                new File(folder.getAbsolutePath() + File.separatorChar + "cache").mkdir();
            }
            cache.saveToFile(new File(folder.getAbsolutePath() + File.separatorChar + "cache/" + kb.hashCode() + ".ser"));
        }
        return cache;
    }

    public static HybridCache getNoPrefixData(KBInfo kb) {
        return HybridCache.getNoPrefixData(new File(""), kb);
    }

    public static HybridCache getNoPrefixData(File folder, KBInfo kb) {
        HybridCache cache = new HybridCache();
        File cacheFile = new File(folder.getAbsolutePath() + File.separatorChar + "cache/" + kb.hashCode() + ".ser");
        try {
            if (cacheFile.exists()) {
                logger.info((Object)("Found cached data. Loading data from file " + cacheFile.getAbsolutePath()));
                cache = HybridCache.loadFromFile(cacheFile);
            }
            if (cache.size() == 0) {
                throw new Exception();
            }
            logger.info((Object)("Cached data loaded successfully from file " + cacheFile.getAbsolutePath()));
            logger.info((Object)("Size = " + cache.size()));
        }
        catch (Exception e) {
            logger.info((Object)("No cached data found for " + kb.id));
            NoPrefixSparqlQueryModule module = new NoPrefixSparqlQueryModule(kb);
            module.fillCache(cache);
            if (!new File(folder.getAbsolutePath() + File.separatorChar + "cache").exists() || !new File(folder.getAbsolutePath() + File.separatorChar + "cache").isDirectory()) {
                new File(folder.getAbsolutePath() + File.separatorChar + "cache").mkdir();
            }
            cache.saveToFile(new File(folder.getAbsolutePath() + File.separatorChar + "cache/" + kb.hashCode() + ".ser"));
        }
        return cache;
    }

    @Override
    public Cache getSample(int size) {
        MemoryCache c = new MemoryCache();
        ArrayList<String> uris = this.getAllUris();
        while (c.size() < 1000) {
            int index = (int)Math.floor(Math.random() * (double)this.size());
            Instance i = this.getInstance(uris.get(index));
            c.addInstance(i);
        }
        return c;
    }

    @Override
    public Cache processData(String processingChain) {
        MemoryCache c = new MemoryCache();
        for (Instance instance : this.getAllInstances()) {
            String uri = instance.getUri();
            for (String p : instance.getAllProperties()) {
                for (String value : instance.getProperty(p)) {
                    c.addTriple(uri, p, Preprocessor.process(value, processingChain));
                }
            }
        }
        return c;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }
}

