/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.uni_leipzig.simba.benchmarker.Modifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitModifier
extends Modifier {
    public int partsCount = 2;
    public List<Property> splitProperties = new ArrayList<Property>();

    public void setSplitProperties(List<Property> splitProperties) {
        this.splitProperties = splitProperties;
    }

    public void addSplitProperty(Property splitProperty) {
        this.splitProperties.add(splitProperty);
    }

    public void setPartsCount(int partsCount) {
        this.partsCount = partsCount;
    }

    @Override
    Model destroy(Model subModel) {
        System.out.println();
        System.out.println("Splitting " + subModel.size() + " triples.");
        StmtIterator sItr = subModel.listStatements();
        while (sItr.hasNext()) {
            Statement stat = sItr.nextStatement();
            List<Statement> splitStat = this.split(stat);
            destroyedModel.add(splitStat);
        }
        return destroyedModel;
    }

    private List<Statement> split(Statement stmt) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        if (!stmt.getObject().isLiteral()) {
            System.err.println(stmt.getObject() + " is not a literal object");
            System.err.println("Can NOT split a non-literal object!!");
            result.add(stmt);
            return result;
        }
        Resource subject = stmt.getSubject();
        Property predicate = stmt.getPredicate();
        RDFNode object = stmt.getObject();
        String[] splitObject = object.toString().split(" ", this.partsCount);
        for (int i = 0; i < splitObject.length; ++i) {
            Statement resultStmt;
            Literal newObject = ResourceFactory.createTypedLiteral((Object)splitObject[i]);
            if (this.splitProperties.isEmpty()) {
                Property newPredicate = ResourceFactory.createProperty((String)(predicate.toString() + i));
                resultStmt = ResourceFactory.createStatement((Resource)subject, (Property)newPredicate, (RDFNode)newObject);
            } else {
                resultStmt = ResourceFactory.createStatement((Resource)subject, (Property)this.splitProperties.get(i), (RDFNode)newObject);
            }
            result.add(resultStmt);
        }
        return result;
    }

    public static void main(String[] args) {
        SplitModifier sM = new SplitModifier();
        Resource s = ResourceFactory.createResource((String)"medo.test");
        Literal o = ResourceFactory.createTypedLiteral((Object)"Medo koko dodo");
        Statement stmt = ResourceFactory.createStatement((Resource)s, (Property)RDFS.label, (RDFNode)o);
        sM.setPartsCount(3);
        ArrayList<Property> sP = new ArrayList<Property>();
        sM.setSplitProperties(sP);
        System.out.println(sP);
        System.out.println(sM.split(stmt));
        System.out.println(o);
        System.out.println(o.asNode().getLiteral().getLexicalForm());
    }
}

