/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import de.uni_leipzig.simba.benchmarker.Modifier;

public class PermutationModifier
extends Modifier {
    Model destroy(Model subModel) {
        System.out.println();
        System.out.println("Performing permutation of " + subModel.size() + " triples.");
        StmtIterator sItr = subModel.listStatements();
        while (sItr.hasNext()) {
            Statement stmt = sItr.nextStatement();
            Statement permutatedStatement = this.permutat(stmt);
            destroyedModel.add(permutatedStatement);
        }
        return destroyedModel;
    }

    private Statement permutat(Statement stmt) {
        if (!stmt.getObject().isLiteral()) {
            System.err.println(stmt.getObject() + " is not a literal object");
            System.err.println("Can NOT permutat a non-literal object!!");
            return stmt;
        }
        String objectLitral = stmt.getObject().asNode().getLiteral().getLexicalForm();
        String permutatedLitral = this.permutat(objectLitral);
        Literal permutatedObject = ResourceFactory.createTypedLiteral((Object)permutatedLitral);
        Statement result = ResourceFactory.createStatement((Resource)stmt.getSubject(), (Property)stmt.getPredicate(), (RDFNode)permutatedObject);
        return result;
    }

    private String permutat(String s) {
        String result = new String();
        if (s.contains(" ")) {
            String[] splitStr = s.split(" ", 2);
            result = splitStr[1] + " " + splitStr[0];
        } else {
            result = s;
        }
        return result;
    }
}

