/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Modifier {
    static Model baseModel = ModelFactory.createDefaultModel();
    static Model destroyedPropertiesModel = ModelFactory.createDefaultModel();
    static Model destroyedModel = ModelFactory.createDefaultModel();
    static List<Property> properties = new ArrayList<Property>();
    double destructionRatio = 0.5;
    long destroyedInstancesCount;
    boolean destroyProperty = false;

    abstract Model destroy(Model var1);

    public static Model getDestroyedPropertiesModel() {
        for (Property p : properties) {
            StmtIterator sItr = baseModel.listStatements(null, p, (RDFNode)null);
            while (sItr.hasNext()) {
                Statement stmt = sItr.nextStatement();
                destroyedPropertiesModel.add(stmt);
            }
        }
        return destroyedPropertiesModel;
    }

    public static void setDestroyedPropertiesModel(Model destroyedPropertiesModel) {
        Modifier.destroyedPropertiesModel = destroyedPropertiesModel;
    }

    public List<Property> getProperties() {
        return properties;
    }

    public void setProperties(List<Property> properties) {
        Modifier.properties = properties;
    }

    public void addProperty(Property p) {
        properties.add(p);
    }

    public Model loadModel(String fileNameOrUri) {
        Model model = ModelFactory.createDefaultModel();
        InputStream in = FileManager.get().open(fileNameOrUri);
        if (in == null) {
            throw new IllegalArgumentException("File/URI: " + fileNameOrUri + " not found");
        }
        if (fileNameOrUri.endsWith(".ttl")) {
            System.out.println("Opening Turtle file");
            model.read(in, null, "TTL");
        } else if (fileNameOrUri.endsWith(".rdf")) {
            System.out.println("Opening RDFXML file");
            model.read(in, null);
        } else if (fileNameOrUri.endsWith(".nt")) {
            System.out.println("Opening N-Triples file");
            model.read(in, null, "N-TRIPLE");
        } else {
            System.out.println("Content negotiation to get RDFXML from " + fileNameOrUri);
            model.read(fileNameOrUri);
        }
        System.out.println("loading " + fileNameOrUri + " is done!!");
        System.out.println();
        return model;
    }
}

