/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import de.uni_leipzig.simba.benchmarker.Modifier;
import java.util.Random;

public class MisspellingModifier
extends Modifier {
    private final String alphabet = "abcdefghijklmnopqrstuvwxzyABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final int MISSPELING_MODIFIERS_COUNT = 4;
    private int missplingRate = 1;
    private double permutationRatio = 0.25;
    private double insertionRatio = 0.25;
    private double deletionRatio = 0.25;
    private double substitutionRatio = 0.25;
    private long permutationTriplesCount = 0L;
    private long insertionTriplesCount = 0L;
    private long deletionTriplesCount = 0L;
    private long substitutionTriplesCount = 0L;

    public int getMissplingRate() {
        return this.missplingRate;
    }

    public double getPermutationRatio() {
        return this.permutationRatio;
    }

    public double getInsertionRatio() {
        return this.insertionRatio;
    }

    public double getDeletionRatio() {
        return this.deletionRatio;
    }

    public double getSubstitutionRatio() {
        return this.substitutionRatio;
    }

    public void setMissplingRate(int missplingRate) {
        this.missplingRate = missplingRate;
    }

    public void setPermutationRatio(double permutationRatio) {
        if (permutationRatio < 0.0 || permutationRatio > 1.0) {
            System.out.println(permutationRatio + " must be between 0 and 1, using the default value: " + this.permutationRatio);
            return;
        }
        this.permutationRatio = permutationRatio;
    }

    public void setInsertionRatio(double insertionRatio) {
        if (insertionRatio < 0.0 || insertionRatio > 1.0) {
            System.out.println(insertionRatio + " must be between 0 and 1, using the default value: " + this.insertionRatio);
            return;
        }
        this.insertionRatio = insertionRatio;
    }

    public void setDeletionRatio(double deletionRatio) {
        if (deletionRatio < 0.0 || deletionRatio > 1.0) {
            System.out.println(deletionRatio + " must be between 0 and 1, using the default value: " + this.deletionRatio);
            return;
        }
        this.deletionRatio = deletionRatio;
    }

    public void setSubstitutionRatio(double substitutionRatio) {
        if (substitutionRatio < 0.0 || substitutionRatio > 1.0) {
            System.out.println(substitutionRatio + " must be between 0 and 1, using the default value: " + this.substitutionRatio);
            return;
        }
        this.substitutionRatio = substitutionRatio;
    }

    Model destroy(Model subModel) {
        this.permutationTriplesCount = (long)Math.ceil((double)subModel.size() * this.permutationRatio);
        this.insertionTriplesCount = (long)Math.ceil((double)subModel.size() * this.insertionRatio);
        this.deletionTriplesCount = (long)Math.ceil((double)subModel.size() * this.deletionRatio);
        this.substitutionTriplesCount = this.permutationTriplesCount + this.insertionTriplesCount + this.deletionTriplesCount - subModel.size();
        System.out.println();
        System.out.println("Misspelling " + subModel.size() + " triples.");
        System.out.println("\tMisspelling by character permutation " + this.permutationTriplesCount + " triples.");
        System.out.println("\tMisspelling by character insertion " + this.insertionTriplesCount + " triples.");
        System.out.println("\tMisspelling by character deletion " + this.deletionTriplesCount + " triples.");
        System.out.println("\tMisspelling by character substitution " + this.substitutionTriplesCount + " triples.");
        StmtIterator sItr = subModel.listStatements();
        while (sItr.hasNext()) {
            Statement stmt = sItr.nextStatement();
            Statement misspelledStatement = this.misspelling(stmt);
            destroyedModel.add(misspelledStatement);
        }
        return destroyedModel;
    }

    private Statement misspelling(Statement stmt) {
        if (!stmt.getObject().isLiteral()) {
            System.err.println(stmt.getObject() + " is not a literal object");
            System.err.println("Can NOT misspelling a non-literal object!!");
            return stmt;
        }
        String objectLitral = stmt.getObject().asNode().getLiteral().getLexicalForm();
        String misspelledLitral = new String();
        if (this.permutationTriplesCount > 0L) {
            misspelledLitral = this.charPermutation(objectLitral);
            --this.permutationTriplesCount;
        } else if (this.insertionTriplesCount > 0L) {
            misspelledLitral = this.charInsertion(objectLitral);
            --this.insertionTriplesCount;
        } else if (this.deletionTriplesCount > 0L) {
            misspelledLitral = this.charDeletion(objectLitral);
            --this.deletionTriplesCount;
        } else if (this.substitutionTriplesCount > 0L) {
            misspelledLitral = this.charSubstitution(objectLitral);
            --this.substitutionTriplesCount;
        }
        Literal misspelledObject = ResourceFactory.createTypedLiteral((Object)misspelledLitral);
        Statement result = ResourceFactory.createStatement((Resource)stmt.getSubject(), (Property)stmt.getPredicate(), (RDFNode)misspelledObject);
        return result;
    }

    private String charSubstitution(String s) {
        String result = new String();
        Random generator = new Random();
        for (int i = 0; i < this.missplingRate; ++i) {
            try {
                int randAlphaIndex = generator.nextInt("abcdefghijklmnopqrstuvwxzyABCDEFGHIJKLMNOPQRSTUVWXYZ".length());
                int randIndexS = generator.nextInt(s.length());
                result = s.replace(s.charAt(randIndexS), "abcdefghijklmnopqrstuvwxzyABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(randAlphaIndex));
                continue;
            }
            catch (Exception e) {
                result = s.length() >= 2 ? s.replace(s.charAt(0), 'X') : s;
            }
        }
        return result;
    }

    private String charDeletion(String s) {
        String result = new String();
        Random generator = new Random();
        for (int i = 0; i < this.missplingRate; ++i) {
            try {
                int randIndexS = generator.nextInt(s.length());
                String sub1 = s.substring(0, randIndexS);
                String sub2 = s.substring(randIndexS + 1);
                result = sub1 + sub2;
                continue;
            }
            catch (Exception e) {
                result = s.length() >= 2 ? s.substring(1) : s;
            }
        }
        return result;
    }

    private String charInsertion(String s) {
        String result = new String();
        Random generator = new Random();
        for (int i = 0; i < this.missplingRate; ++i) {
            try {
                int randAlphaIndex = generator.nextInt("abcdefghijklmnopqrstuvwxzyABCDEFGHIJKLMNOPQRSTUVWXYZ".length());
                int randIndexS = generator.nextInt(s.length());
                randIndexS = randIndexS == s.length() ? randIndexS - 1 : randIndexS;
                String sub1 = s.substring(0, randIndexS);
                String sub2 = s.substring(randIndexS);
                result = sub1 + "abcdefghijklmnopqrstuvwxzyABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(randAlphaIndex) + sub2;
                continue;
            }
            catch (Exception e) {
                result = s.length() >= 2 ? 'X' + s : s;
            }
        }
        return result;
    }

    private String charPermutation(String s) {
        String result = new String();
        Random generator = new Random();
        for (int i = 0; i < this.missplingRate; ++i) {
            try {
                int randIndexS = generator.nextInt(s.length());
                int neighborIndex = randIndexS == s.length() ? randIndexS - 1 : randIndexS + 1;
                char[] charArray = s.toCharArray();
                char tmp = charArray[neighborIndex];
                charArray[neighborIndex] = charArray[randIndexS];
                charArray[randIndexS] = tmp;
                result = new String(charArray);
                continue;
            }
            catch (Exception e) {
                if (s.length() >= 2) {
                    char[] charArray = s.toCharArray();
                    char tmp = charArray[0];
                    charArray[0] = charArray[1];
                    charArray[1] = tmp;
                    result = new String(charArray);
                    continue;
                }
                result = s;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        MisspellingModifier m = new MisspellingModifier();
        System.out.println("charDeletion: " + m.charDeletion("abcd"));
        System.out.println("charInsertion: " + m.charInsertion("abcd"));
        System.out.println("charPermutation: " + m.charPermutation("abcd"));
        System.out.println("charSubstitution: " + m.charSubstitution("abcd"));
        System.out.println(Math.floor(0.0));
    }
}

