/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.uni_leipzig.simba.benchmarker.Modifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeModifier
extends Modifier {
    public Property mergeProperty;

    public Property getMergeProperty() {
        return this.mergeProperty;
    }

    public void setMergeProperty(Property mergeProperty) {
        this.mergeProperty = mergeProperty;
    }

    @Override
    Model destroy(Model subModel) {
        System.out.println();
        long n = subModel.size() % 2L == 0L ? subModel.size() : subModel.size() - 1L;
        System.out.println("Merging " + n + " triples.");
        StmtIterator sItr = subModel.listStatements();
        while (sItr.hasNext()) {
            Statement stat1 = sItr.nextStatement();
            if (sItr.hasNext()) {
                Statement stat2 = sItr.nextStatement();
                ArrayList<Statement> stmts = new ArrayList<Statement>();
                stmts.add(stat1);
                stmts.add(stat2);
                Statement mergedStatement = this.merge(stmts);
                destroyedModel.add(mergedStatement);
                continue;
            }
            destroyedModel.add(stat1);
        }
        return destroyedModel;
    }

    private Statement merge(List<Statement> stmts) {
        Statement result = null;
        String mergeObjectStr = new String();
        Resource subject = null;
        Property predicate = null;
        RDFNode object = null;
        for (Statement stmt : stmts) {
            if (!stmt.getObject().isLiteral()) {
                System.err.println(stmt.getObject() + " is not a literal object");
                System.err.println("Can NOT merge a non-literal object!!");
                return stmt;
            }
            subject = stmt.getSubject();
            predicate = stmt.getPredicate();
            object = stmt.getObject();
            mergeObjectStr = mergeObjectStr.concat(object.asNode().getLiteral().getLexicalForm() + " ");
        }
        mergeObjectStr = mergeObjectStr.substring(0, mergeObjectStr.length() - 1);
        Literal mergeObject = ResourceFactory.createTypedLiteral((Object)mergeObjectStr);
        result = this.mergeProperty == null ? ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)mergeObject) : ResourceFactory.createStatement((Resource)subject, (Property)this.mergeProperty, (RDFNode)mergeObject);
        return result;
    }

    public static void main(String[] args) {
        MergeModifier mM = new MergeModifier();
        Resource s = ResourceFactory.createResource((String)"medo.test");
        Literal o1 = ResourceFactory.createTypedLiteral((Object)"koko");
        Literal o2 = ResourceFactory.createTypedLiteral((Object)"Medo");
        Statement stmt1 = ResourceFactory.createStatement((Resource)s, (Property)RDFS.label, (RDFNode)o1);
        Statement stmt2 = ResourceFactory.createStatement((Resource)s, (Property)RDFS.label, (RDFNode)o2);
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        stmts.add(stmt1);
        stmts.add(stmt2);
        mM.mergeProperty = ResourceFactory.createProperty((String)"testProperty");
        System.out.println(mM.merge(stmts));
    }
}

