/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkGenerator {
    Model baseModel;
    Model destroyedModel;
    List<Property> properties;
    double destructionRatio = 0.5;
    long destroyedInstancesCount;
    long misspellingInstancesCount = 0L;
    long permutationInstancesCount = 0L;
    long abbreviationInstancesCount = 0L;
    final int modifiersCount = 3;

    public BenchmarkGenerator(Model baseModel, double destructionRatio, List<Property> properties, double misspellingInstancesRatio, double permutationInstancesRatio, double abbreviationInstancesRatio) {
        this.baseModel = baseModel;
        this.destructionRatio = destructionRatio;
        this.properties = properties;
        this.destroyedInstancesCount = (long)((double)this.getInstantsCount() * destructionRatio);
        this.misspellingInstancesCount = (long)((double)this.destroyedInstancesCount * misspellingInstancesRatio);
        this.permutationInstancesCount = (long)((double)this.destroyedInstancesCount * permutationInstancesRatio);
        this.abbreviationInstancesCount = (long)((double)this.destroyedInstancesCount * abbreviationInstancesRatio);
    }

    public BenchmarkGenerator(String fileName, double destructionRatio, List<Property> properties, double misspellingInstancesRatio, double permutationInstancesRatio, double abbreviationInstancesRatio) {
        this.baseModel = this.loadModel(fileName);
        this.destructionRatio = destructionRatio;
        this.properties = properties;
        this.destroyedInstancesCount = (long)((double)this.getInstantsCount() * destructionRatio);
        this.misspellingInstancesCount = (long)((double)this.destroyedInstancesCount * misspellingInstancesRatio);
        this.permutationInstancesCount = (long)((double)this.destroyedInstancesCount * permutationInstancesRatio);
        this.abbreviationInstancesCount = (long)((double)this.destroyedInstancesCount * abbreviationInstancesRatio);
    }

    public Model getDistroyedModel() {
        boolean finished = false;
        String objectText = null;
        String objectType = null;
        String objectLangTag = null;
        Literal destroyedObject = null;
        this.destroyedModel = ModelFactory.createDefaultModel();
        this.destroyedInstancesCount = (int)((double)this.getInstantsCount() * this.destructionRatio);
        StmtIterator sItr = this.baseModel.listStatements();
        while (sItr.hasNext()) {
            Statement stat = sItr.nextStatement();
            Resource subject = stat.getSubject();
            Property predicate = stat.getPredicate();
            RDFNode object = stat.getObject();
            if (this.destroyedInstancesCount > 0L && this.properties.contains(predicate) && object.isLiteral()) {
                if (object.toString().contains("^")) {
                    objectText = object.toString().substring(0, object.toString().indexOf("^"));
                    objectType = object.toString().substring(object.toString().indexOf("^"), object.toString().length()).replace("^^", "");
                    TypeMapper tm = new TypeMapper();
                    destroyedObject = ResourceFactory.createTypedLiteral((String)this.destroy(objectText), (RDFDatatype)tm.getSafeTypeByName(objectType));
                    this.destroyedModel.add(subject, predicate, (RDFNode)destroyedObject);
                } else if (object.toString().contains("@")) {
                    objectText = object.toString().substring(0, object.toString().indexOf("@"));
                    objectLangTag = object.toString().substring(object.toString().indexOf("@"), object.toString().length()).replace("@", "");
                    Resource r = this.destroyedModel.createResource(subject);
                    r.addProperty(predicate, objectText, objectLangTag);
                } else {
                    objectText = object.toString();
                    destroyedObject = ResourceFactory.createPlainLiteral((String)this.destroy(objectText));
                    this.destroyedModel.add(subject, predicate, (RDFNode)destroyedObject);
                }
                --this.destroyedInstancesCount;
                continue;
            }
            this.destroyedModel.add(stat);
        }
        return this.destroyedModel;
    }

    private String destroy(String s) {
        String result = s;
        if (this.permutationInstancesCount > 0L && (result = this.permutationModifier(s)) != s) {
            --this.permutationInstancesCount;
            return result;
        }
        if (this.abbreviationInstancesCount > 0L && (result = this.abbreviationModifier(s)) != s) {
            --this.abbreviationInstancesCount;
            return result;
        }
        if (this.misspellingInstancesCount > 0L && (result = this.misspellingModifier(s)) != s) {
            --this.misspellingInstancesCount;
            return result;
        }
        result = this.misspellingModifier(s);
        return result;
    }

    public Model getBaseModel() {
        return this.baseModel;
    }

    public double getDestructionRatio() {
        return this.destructionRatio;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setBaseModel(Model baseModel) {
        this.baseModel = baseModel;
    }

    public void setDestructionRatio(double destructionRatio) {
        this.destructionRatio = destructionRatio;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    private String misspellingModifier(String s) {
        String result = new String();
        Random generator = new Random();
        try {
            int i = generator.nextInt(s.length());
            int j = generator.nextInt(s.length());
            result = s.replace(s.charAt(i), s.charAt(j));
        }
        catch (Exception e) {
            result = s.length() >= 2 ? s.replace(s.charAt(0), s.charAt(1)) : s;
        }
        return result;
    }

    private String abbreviationModifier(String s) {
        if (s.length() <= 2) {
            return s;
        }
        String result = new String();
        Random generator = new Random();
        if (s.contains(" ")) {
            int randIndex;
            String[] splitStr = s.split(" ", 10);
            try {
                randIndex = generator.nextInt(splitStr.length);
                if (splitStr[randIndex].length() == 0) {
                    randIndex = 0;
                }
            }
            catch (Exception e) {
                randIndex = 0;
            }
            if (!splitStr[randIndex].equals(" ") && !splitStr[randIndex].equals("")) {
                splitStr[randIndex] = splitStr[randIndex].replace(splitStr[randIndex].substring(1), ".");
            }
            for (int i = 0; i < splitStr.length; ++i) {
                result = result + splitStr[i] + " ";
            }
        } else {
            result = s.replace(s.substring(1), ".");
        }
        return result;
    }

    private String permutationModifier(String s) {
        String result = new String();
        if (s.contains(" ")) {
            String[] splitStr = s.split(" ", 2);
            result = splitStr[1] + " " + splitStr[0];
        } else {
            result = s;
        }
        return result;
    }

    private int getInstantsCount() {
        int instancesCount = 0;
        for (Property prop : this.properties) {
            String sparqlQueryString = "SELECT ?o {?s <" + prop.toString() + "> ?o}";
            QueryFactory.create((String)sparqlQueryString);
            QueryExecution qexec = QueryExecutionFactory.create((String)sparqlQueryString, (Model)this.baseModel);
            ResultSet queryResults = qexec.execSelect();
            while (queryResults.hasNext()) {
                queryResults.nextSolution();
                ++instancesCount;
            }
        }
        return instancesCount;
    }

    public Model loadModel(String fileNameOrUri) {
        Model model = ModelFactory.createDefaultModel();
        InputStream in = FileManager.get().open(fileNameOrUri);
        if (in == null) {
            throw new IllegalArgumentException("File/URI: " + fileNameOrUri + " not found");
        }
        if (fileNameOrUri.endsWith(".ttl")) {
            System.out.println("Opening Turtle file");
            model.read(in, null, "TTL");
        } else if (fileNameOrUri.endsWith(".rdf")) {
            System.out.println("Opening RDFXML file");
            model.read(in, null);
        } else if (fileNameOrUri.endsWith(".nt")) {
            System.out.println("Opening N-Triples file");
            model.read(in, null, "N-TRIPLE");
        } else {
            System.out.println("Content negotiation to get RDFXML from " + fileNameOrUri);
            model.read(fileNameOrUri);
        }
        System.out.println("loading " + fileNameOrUri + " is done!!");
        System.out.println();
        return model;
    }

    public BenchmarkGenerator() {
    }

    public static List<String> getBenchmarkedFiles(String baseFileName, List<Property> props, List<Double> destructionValues) throws IOException {
        ArrayList<String> resultFiles = new ArrayList<String>();
        int count = 1;
        for (Double dRatio : destructionValues) {
            BenchmarkGenerator bmGen = new BenchmarkGenerator(baseFileName, (double)dRatio, props, 0.3333, 0.3333, 0.3333);
            String newBenchmarkFileName = baseFileName.substring(0, baseFileName.lastIndexOf("/")) + baseFileName.substring(baseFileName.lastIndexOf("/"), baseFileName.indexOf(".")) + "_" + dRatio + "_" + count + ".ttl";
            System.out.println("Generating File: " + newBenchmarkFileName);
            FileWriter outFile = new FileWriter(newBenchmarkFileName);
            bmGen.getDistroyedModel().write((Writer)outFile, "TURTLE");
            System.out.println("... Done!");
            resultFiles.add(newBenchmarkFileName);
            ++count;
        }
        return resultFiles;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("No Propertis found!");
        }
        ArrayList<Property> propList = new ArrayList<Property>();
        for (int i = 1; i < args.length; ++i) {
            propList.add(ResourceFactory.createProperty((String)args[i]));
        }
        BenchmarkGenerator g = new BenchmarkGenerator(args[0], 0.5, propList, 0.3333, 0.3333, 0.3333);
        System.out.println("destroyedInstancesCount: " + g.destroyedInstancesCount + "\n" + "misspellingInstancesCount: " + g.misspellingInstancesCount + "\n" + "permutationInstancesCount: " + g.permutationInstancesCount + "\n" + "abbreviationInstancesCount: " + g.abbreviationInstancesCount);
        System.out.println("Instances No. of the Base Model = " + g.getInstantsCount());
        g.getDistroyedModel();
        System.out.println("\n\ndestroyedInstancesCount: " + g.destroyedInstancesCount + "\n" + "misspellingInstancesCount: " + g.misspellingInstancesCount + "\n" + "permutationInstancesCount: " + g.permutationInstancesCount + "\n" + "abbreviationInstancesCount: " + g.abbreviationInstancesCount);
        System.out.println("Instances No. of the Base Model = " + g.getInstantsCount());
    }
}

