/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import de.uni_leipzig.simba.benchmarker.Modifier;

public class AcronymModifier
extends Modifier {
    public int maxAcronymLength = 4;

    Model destroy(Model subModel) {
        System.out.println();
        System.out.println("Generating acronym of " + subModel.size() + " triples.");
        StmtIterator sItr = subModel.listStatements();
        while (sItr.hasNext()) {
            Statement stmt = sItr.nextStatement();
            Statement acronyamedStatement = this.acronyam(stmt);
            destroyedModel.add(acronyamedStatement);
        }
        return destroyedModel;
    }

    private Statement acronyam(Statement stmt) {
        if (!stmt.getObject().isLiteral()) {
            System.err.println(stmt.getObject() + " is not a literal object");
            System.err.println("Can NOT get acronyam for non-literal object!!");
            return stmt;
        }
        String objectLitral = stmt.getObject().asNode().getLiteral().getLexicalForm();
        String acronyamedLitral = this.acronyam(objectLitral);
        Literal acronyamedObject = ResourceFactory.createTypedLiteral((Object)acronyamedLitral);
        Statement result = ResourceFactory.createStatement((Resource)stmt.getSubject(), (Property)stmt.getPredicate(), (RDFNode)acronyamedObject);
        return result;
    }

    private String acronyam(String s) {
        if (s.length() < 2) {
            return s;
        }
        String result = new String();
        if (s.contains(" ")) {
            int i;
            String[] splitStr = s.split(" ", Integer.MAX_VALUE);
            for (i = 0; i < Math.min(this.maxAcronymLength, splitStr.length); ++i) {
                if (splitStr[i].equals(" ") || splitStr[i].equals("")) continue;
                result = result + splitStr[i].replace(splitStr[i].substring(1), "");
            }
            result = result.toUpperCase();
            while (i < splitStr.length) {
                result = result + " " + splitStr[i];
                ++i;
            }
        } else {
            result = s.replace(s.substring(1), "").toUpperCase();
        }
        return result;
    }

    public static void main(String[] args) {
        AcronymModifier a = new AcronymModifier();
        System.out.println(a.acronyam("sdsadasd jkhkh kjkljl jhkjh jkbnk"));
    }
}

