/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.benchmarker;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import de.uni_leipzig.simba.benchmarker.Modifier;
import java.util.Random;

public class AbbreviationModifier
extends Modifier {
    Model destroy(Model subModel) {
        System.out.println();
        System.out.println("Abbriavating " + subModel.size() + " triples.");
        StmtIterator sItr = subModel.listStatements();
        while (sItr.hasNext()) {
            Statement stmt = sItr.nextStatement();
            Statement abbreviatedStatement = this.abbreviat(stmt);
            destroyedModel.add(abbreviatedStatement);
        }
        return destroyedModel;
    }

    private Statement abbreviat(Statement stmt) {
        if (!stmt.getObject().isLiteral()) {
            System.err.println(stmt.getObject() + " is not a literal object");
            System.err.println("Unable to abbreviat a non-literal object!!");
            return stmt;
        }
        String objectLitral = stmt.getObject().asNode().getLiteral().getLexicalForm();
        String abbreviatedLitral = this.abbreviat(objectLitral);
        Literal abbreviatedObject = ResourceFactory.createTypedLiteral((Object)abbreviatedLitral);
        Statement result = ResourceFactory.createStatement((Resource)stmt.getSubject(), (Property)stmt.getPredicate(), (RDFNode)abbreviatedObject);
        return result;
    }

    private String abbreviat(String s) {
        if (s.length() <= 2) {
            return s;
        }
        String result = new String();
        Random generator = new Random();
        if (s.contains(" ")) {
            int randIndex;
            String[] splitStr = s.split(" ", 10);
            try {
                randIndex = generator.nextInt(splitStr.length);
                if (splitStr[randIndex].length() == 0) {
                    randIndex = 0;
                }
            }
            catch (Exception e) {
                randIndex = 0;
            }
            if (!splitStr[randIndex].equals(" ") && !splitStr[randIndex].equals("")) {
                splitStr[randIndex] = splitStr[randIndex].replace(splitStr[randIndex].substring(1), ".");
            }
            for (int i = 0; i < splitStr.length; ++i) {
                result = result + splitStr[i] + " ";
            }
        } else {
            result = s.replace(s.substring(1), ".");
        }
        return result;
    }
}

