/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.translation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ReachabilityGraph<T> {
    private Map<T, Set<T>> reachableMap = new HashMap<T, Set<T>>();

    public void addReachable(T orig, Set<T> dest) {
        this.addVertices(Collections.singleton(orig));
        this.addVertices(dest);
        Set<T> allReachableVertices = this.reachableMap.get(orig);
        allReachableVertices.addAll(dest);
        for (T elem : dest) {
            allReachableVertices.addAll((Collection)this.reachableMap.get(elem));
        }
        for (T elem : this.getVertices()) {
            Set<T> accVertices = this.reachableMap.get(elem);
            if (!accVertices.contains(orig)) continue;
            accVertices.addAll(allReachableVertices);
        }
    }

    public void addReachable(T orig, T dest) {
        this.addReachable(orig, (T)Collections.singleton(dest));
    }

    public void addVertices(Set<T> newVertices) {
        for (T elem : newVertices) {
            if (this.reachableMap.get(elem) != null) continue;
            this.reachableMap.put(elem, new HashSet());
        }
    }

    public Set<T> getDirectSuccessors(T vertex) {
        HashSet<Object> ret = new HashSet<Object>();
        Map<T, Set<T>> map = this.makeMapWithoutEquivalentVertices();
        HashSet connectedVertices = new HashSet();
        connectedVertices.addAll(map.get(vertex));
        HashMap count = new HashMap();
        for (Object elem : connectedVertices) {
            count.put(elem, map.get(elem).size());
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            Object otherVertex = null;
            Iterator it = connectedVertices.iterator();
            while (otherVertex == null && it.hasNext()) {
                Object elem = it.next();
                if ((Integer)count.get(elem) != 0) continue;
                otherVertex = elem;
            }
            if (otherVertex == null) continue;
            changed = true;
            boolean directlyConnected = true;
            for (Object elem : connectedVertices) {
                if (!map.get(elem).contains(otherVertex)) continue;
                count.put(elem, (Integer)count.get(elem) - 1);
                directlyConnected = false;
            }
            if (directlyConnected) {
                ret.add(otherVertex);
            }
            connectedVertices.remove(otherVertex);
        }
        return ret;
    }

    public Set<Set<T>> getEquivalentClasses() {
        HashSet<Set<T>> ret = new HashSet<Set<T>>();
        HashSet<T> visited = new HashSet<T>();
        for (T elem : this.getVertices()) {
            if (visited.contains(elem)) continue;
            Set<T> equivVertices = this.getEquivalentVertices(elem);
            ret.add(equivVertices);
            visited.addAll(equivVertices);
        }
        return ret;
    }

    public Set<T> getEquivalentVertices(T orig) {
        HashSet<T> ret = new HashSet<T>();
        ret.add(orig);
        for (T otherElem : this.reachableMap.get(orig)) {
            if (!this.reachableMap.get(otherElem).contains(orig)) continue;
            ret.add(otherElem);
        }
        return ret;
    }

    public Set<T> getReachableVertices(T orig) {
        return Collections.unmodifiableSet(this.reachableMap.get(orig));
    }

    public Set<T> getVertices() {
        return Collections.unmodifiableSet(this.reachableMap.keySet());
    }

    protected Map<T, Set<T>> makeMapWithoutEquivalentVertices() {
        HashMap ret = new HashMap();
        for (T elem : this.getVertices()) {
            HashSet otherSet = new HashSet();
            otherSet.addAll(this.reachableMap.get(elem));
            if (otherSet.contains(elem)) {
                otherSet.removeAll(this.getEquivalentVertices(elem));
            }
            ret.put(elem, otherSet);
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (T vertex : this.getVertices()) {
            ret.append("(" + vertex.toString() + ") > (");
            for (T otherVertex : this.reachableMap.get(vertex)) {
                ret.append(" (" + otherVertex.toString() + ") ");
            }
            ret.append(")\n");
        }
        return ret.toString();
    }
}

